<?php
require 'db.php';
require 'auth.php';
require_login();

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
  $nama = trim($_POST['nama'] ?? '');
  $jabatan = trim($_POST['jabatan'] ?? '');
  $tujuan = trim($_POST['tujuan'] ?? '');
  $nomor_perkara = trim($_POST['nomor_perkara'] ?? '');
  $nama_pihak = trim($_POST['nama_pihak'] ?? '');
  $nama_pihak_lain = trim($_POST['nama_pihak_lain'] ?? '');
  $tanggal_ambil = $_POST['tanggal_ambil'] ?? '';
  $lama = (int)($_POST['lama'] ?? 3);
  $penandatangan = $_POST['penandatangan'] ?? '';
  
  // Validate required fields
  if (empty($nama) || empty($jabatan) || empty($tujuan) || empty($nomor_perkara) || 
      empty($nama_pihak) || empty($tanggal_ambil) || empty($penandatangan)) {
    header('Location: index.php?error=Semua field wajib harus diisi');
    exit;
  }
  
  // Calculate return date
  $ta = new DateTime($tanggal_ambil);
  $ta->add(new DateInterval('P'.$lama.'D'));
  $tanggal_kembali = $ta->format('Y-m-d');
  
  try {
    $stmt = $db->prepare("INSERT INTO peminjaman (nama, jabatan, tujuan, nomor_perkara, nama_pihak, nama_pihak_lain, tanggal_ambil, tanggal_kembali, penandatangan) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?)");
    
    $result = $stmt->execute([
      $nama, $jabatan, $tujuan, $nomor_perkara, $nama_pihak, 
      $nama_pihak_lain, $tanggal_ambil, $tanggal_kembali, $penandatangan
    ]);
    
    if ($result) {
      header('Location: index.php?success=1');
    } else {
      header('Location: index.php?error=Gagal menyimpan data');
    }
  } catch (PDOException $e) {
    header('Location: index.php?error=Error: ' . $e->getMessage());
  }
} else {
  header('Location: index.php');
}
exit;
?>
