<?php
echo "<h1>Status File Aplikasi Peminjaman Berkas</h1>";
echo "<p><em>Checking file integrity and status...</em></p>";

$required_files = [
    'db.php' => 'Database configuration and connection',
    'auth.php' => 'Authentication functions',
    'login.php' => 'Login page',
    'logout.php' => 'Logout handler',
    'index.php' => 'Main dashboard',
    'save.php' => 'Save new peminjaman',
    'update.php' => 'Update existing peminjaman',
    'delete.php' => 'Delete peminjaman',
    'return.php' => 'Return berkas process',
    'extend.php' => 'Extend peminjaman',
    'print.php' => 'Print surat peminjaman',
    'bukti.php' => 'Print bukti pengembalian',
    'admin.php' => 'Admin settings',
    'settings_save.php' => 'Save admin settings'
];

echo "<h3>File Status:</h3>";
echo "<table border='1' style='border-collapse:collapse; width:100%;'>";
echo "<tr><th>File</th><th>Status</th><th>Size</th><th>Description</th></tr>";

foreach ($required_files as $file => $description) {
    $path = __DIR__ . '/' . $file;
    $exists = file_exists($path);
    $size = $exists ? filesize($path) : 0;
    $status = $exists ? ($size > 0 ? '✅ OK' : '⚠️ Empty') : '❌ Missing';
    $color = $exists ? ($size > 0 ? 'green' : 'orange') : 'red';
    
    echo "<tr>";
    echo "<td><code>$file</code></td>";
    echo "<td style='color:$color'><strong>$status</strong></td>";
    echo "<td>" . ($exists ? number_format($size) . " bytes" : "-") . "</td>";
    echo "<td>$description</td>";
    echo "</tr>";
}

echo "</table>";

// Check database connection
echo "<h3>Database Status:</h3>";
try {
    require 'db.php';
    echo "<p style='color:green'>✅ Database connection: OK</p>";
    
    // Check tables
    $tables = ['peminjaman', 'users', 'settings'];
    foreach ($tables as $table) {
        try {
            $count = $db->query("SELECT COUNT(*) FROM $table")->fetchColumn();
            echo "<p style='color:green'>✅ Table '$table': OK ($count records)</p>";
        } catch (Exception $e) {
            echo "<p style='color:red'>❌ Table '$table': Error - " . $e->getMessage() . "</p>";
        }
    }
    
    // Check timezone
    echo "<p><strong>Timezone:</strong> " . date_default_timezone_get() . " (Current time: " . date('Y-m-d H:i:s') . " WITA)</p>";
    
} catch (Exception $e) {
    echo "<p style='color:red'>❌ Database connection failed: " . $e->getMessage() . "</p>";
}

// Check admin folder
echo "<h3>Admin Folder Status:</h3>";
$admin_files = ['users.php', 'user_store.php', 'user_update.php', 'user_delete.php'];
foreach ($admin_files as $file) {
    $path = __DIR__ . '/admin/' . $file;
    $exists = file_exists($path);
    $size = $exists ? filesize($path) : 0;
    $status = $exists ? ($size > 0 ? '✅ OK' : '⚠️ Empty') : '❌ Missing';
    echo "<p>admin/$file: $status</p>";
}

echo "<hr>";
echo "<h3>Quick Actions:</h3>";
echo "<a href='login.php' style='padding:10px; background:#007bff; color:white; text-decoration:none; margin:5px;'>Login</a>";
echo "<a href='index.php' style='padding:10px; background:#28a745; color:white; text-decoration:none; margin:5px;'>Dashboard</a>";
echo "<a href='test-timezone.php' style='padding:10px; background:#ffc107; color:black; text-decoration:none; margin:5px;'>Test Timezone</a>";

echo "<p><em>Status check completed at: " . date('Y-m-d H:i:s') . " WITA</em></p>";
?>
