<?php
/**
 * SCRIPT MIGRATION UNTUK HOSTING
 * 
 * Upload file ini ke hosting rumahweb.com Anda
 * Lalu akses melalui browser: https://pnwtp.site/pinjam-berkas2/fix-database-hosting.php
 * 
 * Script ini akan menambahkan kolom tanggal_tanda_tangan ke database di hosting
 */

echo "<h2>🔧 Database Migration - Hosting Fix</h2>";
echo "<hr>";

// Include database connection
require_once 'db.php';

try {
    // Cek struktur tabel saat ini
    echo "<h3>📋 Struktur Tabel Saat Ini:</h3>";
    $columns = $db->query("PRAGMA table_info(peminjaman)")->fetchAll();
    
    echo "<table border='1' style='border-collapse: collapse; margin: 10px 0;'>";
    echo "<tr><th>Nama Kolom</th><th>Type</th><th>Not Null</th><th>Primary Key</th></tr>";
    
    $columnExists = false;
    foreach ($columns as $column) {
        echo "<tr>";
        echo "<td>" . htmlspecialchars($column['name']) . "</td>";
        echo "<td>" . htmlspecialchars($column['type']) . "</td>";
        echo "<td>" . ($column['notnull'] ? 'YES' : 'NO') . "</td>";
        echo "<td>" . ($column['pk'] ? 'YES' : 'NO') . "</td>";
        echo "</tr>";
        
        if ($column['name'] === 'tanggal_tanda_tangan') {
            $columnExists = true;
        }
    }
    echo "</table>";
    
    echo "<p><strong>Total kolom:</strong> " . count($columns) . "</p>";
    
    // Cek apakah kolom tanggal_tanda_tangan sudah ada
    if ($columnExists) {
        echo "<div style='background: #d4edda; border: 1px solid #c3e6cb; padding: 10px; margin: 10px 0; border-radius: 5px;'>";
        echo "✅ <strong>SUKSES:</strong> Kolom 'tanggal_tanda_tangan' sudah ada!<br>";
        echo "Database Anda sudah up-to-date. Tidak perlu migration.";
        echo "</div>";
    } else {
        echo "<div style='background: #fff3cd; border: 1px solid #ffeaa7; padding: 10px; margin: 10px 0; border-radius: 5px;'>";
        echo "⚠️ <strong>PERLU MIGRATION:</strong> Kolom 'tanggal_tanda_tangan' tidak ditemukan!<br>";
        echo "Menambahkan kolom...";
        echo "</div>";
        
        // Tambahkan kolom tanggal_tanda_tangan
        $db->exec("ALTER TABLE peminjaman ADD COLUMN tanggal_tanda_tangan TEXT");
        
        echo "<div style='background: #d4edda; border: 1px solid #c3e6cb; padding: 10px; margin: 10px 0; border-radius: 5px;'>";
        echo "✅ <strong>BERHASIL:</strong> Kolom 'tanggal_tanda_tangan' berhasil ditambahkan!";
        echo "</div>";
        
        // Verifikasi ulang
        echo "<h3>📋 Struktur Tabel Setelah Migration:</h3>";
        $newColumns = $db->query("PRAGMA table_info(peminjaman)")->fetchAll();
        
        echo "<table border='1' style='border-collapse: collapse; margin: 10px 0;'>";
        echo "<tr><th>Nama Kolom</th><th>Type</th><th>Not Null</th><th>Primary Key</th></tr>";
        
        foreach ($newColumns as $column) {
            $highlight = ($column['name'] === 'tanggal_tanda_tangan') ? "style='background: #d4edda;'" : "";
            echo "<tr $highlight>";
            echo "<td>" . htmlspecialchars($column['name']) . "</td>";
            echo "<td>" . htmlspecialchars($column['type']) . "</td>";
            echo "<td>" . ($column['notnull'] ? 'YES' : 'NO') . "</td>";
            echo "<td>" . ($column['pk'] ? 'YES' : 'NO') . "</td>";
            echo "</tr>";
        }
        echo "</table>";
        
        echo "<p><strong>Total kolom setelah migration:</strong> " . count($newColumns) . "</p>";
    }
    
    echo "<hr>";
    echo "<h3>🧪 Test Insert Data</h3>";
    
    // Test insert data untuk memastikan kolom berfungsi
    $testData = [
        'nama' => 'Test User',
        'jabatan' => 'Test Jabatan', 
        'tujuan' => 'Test migration database',
        'nomor_perkara' => 'TEST/2025/PN.WTP',
        'nama_pihak' => 'Test Pihak',
        'nama_pihak_lain' => '',
        'tanggal_ambil' => date('Y-m-d'),
        'tanggal_kembali' => date('Y-m-d', strtotime('+3 days')),
        'penandatangan' => 'ketua',
        'tanggal_tanda_tangan' => date('Y-m-d')
    ];
    
    $stmt = $db->prepare("INSERT INTO peminjaman (nama, jabatan, tujuan, nomor_perkara, nama_pihak, nama_pihak_lain, tanggal_ambil, tanggal_kembali, penandatangan, tanggal_tanda_tangan) VALUES (?, ?, ?, ?, ?, ?, ?, ?, ?, ?)");
    
    $testResult = $stmt->execute([
        $testData['nama'],
        $testData['jabatan'],
        $testData['tujuan'],
        $testData['nomor_perkara'],
        $testData['nama_pihak'],
        $testData['nama_pihak_lain'],
        $testData['tanggal_ambil'],
        $testData['tanggal_kembali'],
        $testData['penandatangan'],
        $testData['tanggal_tanda_tangan']
    ]);
    
    if ($testResult) {
        $testId = $db->lastInsertId();
        echo "<div style='background: #d4edda; border: 1px solid #c3e6cb; padding: 10px; margin: 10px 0; border-radius: 5px;'>";
        echo "✅ <strong>TEST BERHASIL:</strong> Data test berhasil disimpan dengan ID: $testId<br>";
        echo "Kolom tanggal_tanda_tangan berfungsi dengan baik!";
        echo "</div>";
        
        // Hapus data test
        $db->exec("DELETE FROM peminjaman WHERE id = $testId");
        echo "<p><em>Data test sudah dihapus otomatis.</em></p>";
    } else {
        echo "<div style='background: #f8d7da; border: 1px solid #f5c6cb; padding: 10px; margin: 10px 0; border-radius: 5px;'>";
        echo "❌ <strong>TEST GAGAL:</strong> Masih ada masalah dengan database!";
        echo "</div>";
    }
    
} catch (Exception $e) {
    echo "<div style='background: #f8d7da; border: 1px solid #f5c6cb; padding: 10px; margin: 10px 0; border-radius: 5px;'>";
    echo "❌ <strong>ERROR:</strong> " . htmlspecialchars($e->getMessage());
    echo "</div>";
}

echo "<hr>";
echo "<h3>📝 Langkah Selanjutnya:</h3>";
echo "<ol>";
echo "<li>Jika migration berhasil, silakan coba form peminjaman lagi</li>";
echo "<li>Jika masih error, screenshot halaman ini dan kirim ke developer</li>";
echo "<li>Setelah yakin tidak ada masalah, hapus file ini dari hosting untuk keamanan</li>";
echo "</ol>";

echo "<hr>";
echo "<p><strong>⚠️ PENTING:</strong> Setelah migration berhasil, hapus file <code>fix-database-hosting.php</code> ini dari hosting untuk keamanan!</p>";
echo "<p><em>Waktu eksekusi: " . date('Y-m-d H:i:s') . " WITA</em></p>";
?>
