<?php
// Simple test tanpa authentication
$sipp_config = [
    'host' => '192.168.1.240',
    'dbname' => 'sippbaco',
    'username' => 'pnwtp',
    'password' => 'pnwtp2019',
    'port' => 3306
];

echo "Testing SIPP Database Connection...\n";
echo "==================================\n";

try {
    $dsn = "mysql:host={$sipp_config['host']};port={$sipp_config['port']};dbname={$sipp_config['dbname']};charset=utf8mb4";
    $sipp_db = new PDO($dsn, $sipp_config['username'], $sipp_config['password']);
    $sipp_db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "✓ Database connection successful\n\n";
    
    // Test query with sample search
    $search_term = '123';
    $sql = "SELECT DISTINCT nomor_perkara, nomor_arsip, no_ruang, no_lemari, no_rak, no_berkas 
            FROM arsip 
            WHERE nomor_perkara LIKE ? AND nomor_perkara != '' 
            ORDER BY nomor_perkara ASC 
            LIMIT 3";
    
    echo "Testing query with search term '$search_term':\n";
    
    $stmt = $sipp_db->prepare($sql);
    $stmt->execute(['%' . $search_term . '%']);
    $results = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "Results found: " . count($results) . "\n\n";
    
    if (count($results) > 0) {
        echo "Sample results (JSON format for API):\n";
        echo json_encode($results, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "\n\n";
    } else {
        echo "No results with '123'. Let's check total data...\n";
        
        $count_stmt = $sipp_db->query("SELECT COUNT(*) as total FROM arsip WHERE nomor_perkara != ''");
        $total = $count_stmt->fetchColumn();
        echo "Total records with nomor_perkara: " . $total . "\n\n";
        
        if ($total > 0) {
            echo "First 3 records for testing:\n";
            $sample_stmt = $sipp_db->query("SELECT nomor_perkara, nomor_arsip, no_ruang, no_lemari, no_rak, no_berkas FROM arsip WHERE nomor_perkara != '' LIMIT 3");
            $samples = $sample_stmt->fetchAll(PDO::FETCH_ASSOC);
            echo json_encode($samples, JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "\n";
        }
    }
    
} catch (PDOException $e) {
    echo "✗ Database error: " . $e->getMessage() . "\n";
} catch (Exception $e) {
    echo "✗ General error: " . $e->getMessage() . "\n";
}
?>
