<?php
require 'db.php'; require 'auth.php'; require_login();
$id=(int)($_GET['id']??0);
$st=$db->prepare('SELECT * FROM peminjaman WHERE id=?'); $st->execute([$id]);
$row=$st->fetch(PDO::FETCH_ASSOC);
if(!$row){ http_response_code(404); die('Data tidak ditemukan'); }
if($row['status'] !== 'kembali'){ http_response_code(400); die('Berkas belum dikembalikan'); }

$petugas = $_SESSION['user']['nama_lengkap'] ?? $_SESSION['user']['username'] ?? 'petugas';

// Check if already printed before
$sudah_dicetak = !empty($row['bukti_dicetak']) && $row['bukti_dicetak'] == 1;
$info_cetak_sebelum = [];
if ($sudah_dicetak) {
    $info_cetak_sebelum = [
        'waktu' => $row['bukti_dicetak_waktu'] ?? 'Tidak diketahui',
        'oleh' => $row['bukti_dicetak_oleh'] ?? 'Tidak diketahui'
    ];
}

// Set current print time
$waktu_cetak = date('Y-m-d H:i:s');

// Update print info if not admin reprint
if (!$sudah_dicetak || !is_admin()) {
    $updateSt = $db->prepare('UPDATE peminjaman SET bukti_dicetak = 1, bukti_dicetak_waktu = ?, bukti_dicetak_oleh = ? WHERE id = ?');
    $updateSt->execute([$waktu_cetak, $petugas, $id]);
}

$qrdata = $row['id'].'#'.$row['nomor_perkara'].'# telah kembali '.$row['tanggal_kembali_real'].' dan dikonfirmasi petugas atas nama '.$petugas;
$qrurl = 'https://api.qrserver.com/v1/create-qr-code/?size=160x160&data='.urlencode($qrdata);
?><!doctype html><html><head><meta charset="utf-8"><title>Bukti Pengembalian - <?= htmlspecialchars($row['nomor_perkara']) ?></title>
<style>
body{font-family:'Times New Roman',serif;font-size:11pt;margin:0;padding:1.5cm;background:#fff;line-height:1.3;}
@page{size:A4;margin:1.5cm;} 
@media print {
  body{margin:0;padding:1cm;}
  .no-break{page-break-inside:avoid;}
}
.center{text-align:center;} 
table{width:100%;border-collapse:collapse;} 
td{padding:4px 0;vertical-align:top;}
.kop{margin-bottom:15px;}
.kop h3,.kop h4{margin:0 0 4px 0;line-height:1.2;}
.qr-section{margin-top:25px;}
.data-table td{padding:3px 0;}
.compact{font-size:10pt;}
</style></head><body>
<div class="center kop no-break">
  <img src="gambar/kop_surat.png" style="max-width:700px;width:100%;height:auto;margin-bottom:8px"><br>
  <h3><strong>BUKTI PENGEMBALIAN BERKAS PERKARA</strong></h3>
  <h4><strong>KEPANITERAAN HUKUM - PENGADILAN NEGERI WATAMPONE</strong></h4>
</div>

<table class="data-table">
<tr><td style="width:200px">Nama Peminjam</td><td>: <?=htmlspecialchars($row['nama'])?></td></tr>
<tr><td>Jabatan</td><td>: <?=htmlspecialchars($row['jabatan'])?></td></tr>
<tr><td>Nomor Perkara</td><td>: <?=htmlspecialchars($row['nomor_perkara'])?></td></tr>
<tr><td>Nama Pihak</td><td>: <?=htmlspecialchars($row['nama_pihak'])?></td></tr>
<?php if(!empty($row['nama_pihak_lain'])): ?>
<tr><td>Nama Pihak Lain</td><td>: <?=htmlspecialchars($row['nama_pihak_lain'])?></td></tr>
<?php endif; ?>
<tr><td>Tujuan Peminjaman</td><td>: <?=htmlspecialchars($row['tujuan'])?></td></tr>
<tr><td>Tanggal Ambil</td><td>: <?=htmlspecialchars($row['tanggal_ambil'])?></td></tr>
<tr><td>Tanggal Kembali Rencana</td><td>: <?=htmlspecialchars($row['tanggal_kembali'])?></td></tr>
<tr><td>Tanggal Kembali Aktual</td><td>: <?=htmlspecialchars($row['tanggal_kembali_real'])?></td></tr>
<tr><td>Jumlah Perpanjangan</td><td>: <?=$row['perpanjangan_count']?> kali</td></tr>
<tr><td>Status</td><td>: <strong style="color:green;">DIKEMBALIKAN</strong></td></tr>
</table>

<p style="margin:15px 0;font-size:10pt;"><em><strong>Keterangan:</strong> Berkas telah dikembalikan dalam kondisi lengkap dan sesuai dengan ketentuan yang berlaku.</em></p>

<?php if($sudah_dicetak && is_admin()): ?>
<div style="background:#fff3cd;border:1px solid #ffeaa7;padding:10px;margin:15px 0;border-radius:5px;">
  <p style="margin:0;font-size:10pt;color:#856404;"><strong><i class="fa fa-info-circle"></i> INFORMASI ADMIN:</strong></p>
  <p style="margin:5px 0 0 0;font-size:9pt;color:#856404;">
    Bukti pengembalian ini sudah pernah dicetak sebelumnya pada <strong><?= htmlspecialchars($info_cetak_sebelum['waktu']) ?></strong> 
    oleh petugas <strong><?= htmlspecialchars($info_cetak_sebelum['oleh']) ?></strong>. 
    Ini adalah salinan ulang yang dicetak oleh admin.
  </p>
</div>
<?php endif; ?>

<div class="qr-section center">
<table style="width:auto;margin:0 auto;">
<tr>
  <td style="text-align:center;padding-right:20px;">
    <h5 style="margin:0 0 10px 0;font-size:11pt;">Kode Verifikasi Pengembalian</h5>
    <img src="<?=$qrurl?>" width="120" height="120" alt="QR Code"><br>
    <small style="font-size:9pt;">Scan QR Code untuk verifikasi</small>
  </td>
  <td style="text-align:left;vertical-align:top;font-size:9pt;line-height:1.4;">
    <strong>Informasi Verifikasi:</strong><br>
    ID: <?=$row['id']?><br>
    Nomor: <?=htmlspecialchars($row['nomor_perkara'])?><br>
    Dikembalikan: <?=htmlspecialchars($row['tanggal_kembali_real'])?><br>
    <?php if($sudah_dicetak): ?>
    Dicetak Pertama: <?=htmlspecialchars($info_cetak_sebelum['waktu'])?><br>
    Oleh Petugas: <?=htmlspecialchars($info_cetak_sebelum['oleh'])?><br>
    <?php if(is_admin()): ?>
    <strong>Dicetak Ulang: <?=$waktu_cetak?></strong><br>
    <strong>Oleh Admin: <?=htmlspecialchars($petugas)?></strong>
    <?php endif; ?>
    <?php else: ?>
    Dikonfirmasi oleh: <?=htmlspecialchars($petugas)?><br>
    Waktu Cetak: <?=$waktu_cetak?>
    <?php endif; ?>
  </td>
</tr>
</table>
</div>
</div>

<script>window.onload=()=>window.print();</script>
</body></html>
