<?php
if (session_status() === PHP_SESSION_NONE) { session_start(); }

function is_logged_in(){ 
    return isset($_SESSION['user']); 
}

function current_user(){ 
    return $_SESSION['user'] ?? null; 
}

function require_login(){ 
    if(!is_logged_in()){ 
        header('Location: login.php'); 
        exit; 
    } 
}

function require_admin(){ 
    require_login(); 
    if(current_user()['role']!=='admin'){ 
        http_response_code(403); 
        echo 'Akses ditolak.'; 
        exit; 
    } 
}

function is_admin(){
    $user = current_user();
    return $user && $user['role'] === 'admin';
}
?>
