<?php
/**
 * Arsip Auto-Fallback
 * Otomatis gunakan SQLite jika SIPP tidak tersedia (untuk hosting)
 */

require 'auth.php';
require_login();

// Test koneksi SIPP
function testSippConnection() {
    $sipp_config = [
        'host' => '192.168.1.240',
        'dbname' => 'sippbaco',
        'username' => 'pnwtp',
        'password' => 'pnwtp2019',
        'port' => 3306
    ];
    
    try {
        $dsn = "mysql:host={$sipp_config['host']};port={$sipp_config['port']};dbname={$sipp_config['dbname']};charset=utf8mb4";
        $pdo = new PDO($dsn, $sipp_config['username'], $sipp_config['password']);
        $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
        
        // Test query
        $stmt = $pdo->query("SELECT COUNT(*) FROM arsip LIMIT 1");
        $stmt->fetchColumn();
        
        return true;
    } catch (Exception $e) {
        return false;
    }
}

// Cek koneksi SIPP
$sipp_available = testSippConnection();

if ($sipp_available) {
    // Redirect ke arsip SIPP jika tersedia
    header('Location: arsip.php');
    exit();
} else {
    // Redirect ke arsip SQLite jika SIPP tidak tersedia
    header('Location: arsip-sqlite.php?source=auto');
    exit();
}
?>
