# ARSIP SIPP - Dokumentasi

## Deskripsi
Fitur Arsip SIPP adalah modul tambahan dalam DIPARKUM Digitalisasi Peminjaman Arsip Perkara Kepaniteraan Hukum yang memungkinkan semua user untuk melihat dan mencari data arsip perkara dari database SIPP (Sistem Informasi Penelusuran Perkara).

## Fitur

### 1. Menu Arsip SIPP
- Menu baru "Arsip SIPP" tersedia di navbar untuk semua user
- Dapat diakses dari semua halaman utama sistem

### 2. Koneksi Database SIPP
- Koneksi terpisah ke database MySQL SIPP
- Konfigurasi database dapat dikelola di file `sipp_db.php`
- Test koneksi otomatis saat mengakses halaman arsip

### 3. Pencarian Data Arsip
- Pencarian berdasarkan:
  - Nomor perkara
  - Nama pihak
  - Jenis perkara
  - Keterangan
- Hasil pencarian dengan highlighting

### 4. Tampilan Data
- Tampilan tabel responsif dengan informasi:
  - Nomor urut
  - Nomor perkara
  - Nama pihak (utama dan lawan)
  - Jenis perkara (dengan badge)
  - Tanggal daftar
  - Status perkara (dengan badge berwarna)
  - Keterangan (truncated)

### 5. Pagination
- Pagination untuk menangani data dalam jumlah besar
- 50 record per halaman
- Navigasi halaman dengan tombol Previous/Next

## Konfigurasi Database

### File: `sipp_db.php`
```php
$sipp_config = [
    'host' => '192.168.1.240',
    'dbname' => 'sippbaco',
    'username' => 'pnwtp',
    'password' => 'pnwtp2019',
    'port' => 3306,
    'charset' => 'utf8mb4'
];
```

### Fungsi Utama
- `connectSipp()` - Membuat koneksi PDO ke database SIPP
- `testSippConnection()` - Test koneksi dan return status
- `getSippTables()` - Mendapatkan daftar tabel yang tersedia
- `getArsipTableStructure()` - Mendapatkan struktur tabel arsip

## File yang Ditambahkan

1. **arsip.php** - Halaman utama untuk melihat arsip SIPP
2. **sipp_db.php** - Konfigurasi dan fungsi koneksi database SIPP
3. **test-sipp-connection.php** - Halaman test koneksi dan debug

## File yang Dimodifikasi

1. **index.php** - Ditambahkan menu Arsip SIPP di navbar
2. **admin.php** - Ditambahkan menu Arsip SIPP di navbar
3. **admin/users.php** - Ditambahkan menu Arsip SIPP di navbar

## Penggunaan

### Mengakses Arsip SIPP
1. Login ke DIPARKUM Digitalisasi Peminjaman Arsip Perkara Kepaniteraan Hukum
2. Klik menu "Arsip SIPP" di navbar
3. Sistem akan otomatis test koneksi ke database SIPP
4. Jika berhasil, data arsip akan ditampilkan

### Mencari Data
1. Masukkan kata kunci di kotak pencarian
2. Sistem akan mencari di kolom:
   - Nomor perkara
   - Nama pihak
   - Jenis perkara
   - Keterangan
3. Klik tombol "Cari" atau tekan Enter

### Navigasi Data
- Gunakan pagination di bagian bawah untuk navigasi halaman
- Klik "Reset" untuk menampilkan semua data

## Troubleshooting

### Test Koneksi
Akses `test-sipp-connection.php` untuk:
- Melihat status koneksi database SIPP
- Melihat daftar tabel yang tersedia
- Melihat struktur tabel arsip
- Melihat sample data
- Debug informasi konfigurasi

### Error Umum

#### 1. "Gagal terhubung ke database SIPP"
- Periksa konfigurasi database di `sipp_db.php`
- Pastikan server database SIPP dapat diakses
- Periksa username/password database

#### 2. "Tabel 'arsip' tidak ditemukan"
- Pastikan tabel arsip sudah dibuat di database SIPP
- Periksa nama tabel yang benar
- Lihat daftar tabel yang tersedia di test connection

#### 3. "Error query database"
- Periksa struktur tabel arsip
- Pastikan kolom yang dicari sudah ada
- Periksa permission user database

## Keamanan

### Akses Kontrol
- Hanya user yang sudah login yang dapat mengakses
- Menggunakan sistem autentikasi yang sama dengan sistem utama
- Tidak ada modifikasi data, hanya read-only

### Database Security
- Koneksi menggunakan prepared statements
- Password database tidak ditampilkan di interface
- Error handling yang aman tanpa expose informasi sensitif

## Performa

### Optimasi
- Pagination untuk menghindari load data berlebihan
- Query dengan LIMIT untuk performa
- Index sebaiknya ditambahkan di kolom yang sering dicari

### Monitoring
- Error log otomatis untuk debugging
- Connection pooling untuk efisiensi koneksi

## Pengembangan Lanjutan

### Fitur yang Bisa Ditambahkan
1. Filter berdasarkan tanggal
2. Export data ke Excel/PDF
3. Filter berdasarkan jenis perkara
4. Sort kolom
5. Detail view per perkara
6. Statistik arsip

### Integrasi
- Bisa diintegrasikan dengan sistem lain yang menggunakan database SIPP
- API endpoint untuk aplikasi mobile
- Sinkronisasi dengan sistem backup

## Maintenance

### Regular Check
1. Test koneksi database secara berkala
2. Monitor performa query
3. Update konfigurasi jika ada perubahan server
4. Backup konfigurasi database

### Update
- Update file `sipp_db.php` jika ada perubahan konfigurasi database
- Update query di `arsip.php` jika ada perubahan struktur tabel
- Test fitur setelah update sistem utama
