<?php
// Simple test untuk koneksi SIPP tanpa UI
require 'sipp_db.php';

echo "=== TEST KONEKSI DATABASE SIPP ===\n\n";

// Test basic connection
echo "1. Test Koneksi Dasar:\n";
$connection_test = testSippConnection();
echo "   Status: " . ($connection_test['success'] ? 'BERHASIL' : 'GAGAL') . "\n";
echo "   Pesan: " . $connection_test['message'] . "\n\n";

if ($connection_test['success']) {
    // Test get tables
    echo "2. Test Daftar Tabel:\n";
    $tables = getSippTables();
    if ($tables) {
        echo "   Ditemukan " . count($tables) . " tabel:\n";
        foreach($tables as $table) {
            echo "   - " . $table . "\n";
        }
        
        // Check if arsip table exists
        $arsip_exists = in_array('arsip', $tables);
        echo "\n   Tabel 'arsip': " . ($arsip_exists ? 'DITEMUKAN' : 'TIDAK DITEMUKAN') . "\n\n";
        
        if ($arsip_exists) {
            // Test arsip table structure
            echo "3. Test Struktur Tabel Arsip:\n";
            $structure = getArsipTableStructure();
            if ($structure) {
                echo "   Kolom yang tersedia:\n";
                foreach($structure as $column) {
                    echo "   - " . $column['Field'] . " (" . $column['Type'] . ")\n";
                }
                
                // Test sample query
                echo "\n4. Test Query Sample Data:\n";
                $sipp_db = connectSipp();
                if ($sipp_db) {
                    try {
                        $stmt = $sipp_db->query("SELECT COUNT(*) as total FROM arsip");
                        $result = $stmt->fetch();
                        echo "   Total record di tabel arsip: " . $result['total'] . "\n";
                        
                        if ($result['total'] > 0) {
                            $stmt = $sipp_db->query("SELECT * FROM arsip LIMIT 1");
                            $sample = $stmt->fetch();
                            echo "   Sample data pertama:\n";
                            foreach($sample as $key => $value) {
                                echo "   - " . $key . ": " . (strlen($value) > 50 ? substr($value, 0, 50) . '...' : $value) . "\n";
                            }
                        }
                    } catch (PDOException $e) {
                        echo "   Error: " . $e->getMessage() . "\n";
                    }
                }
            } else {
                echo "   Gagal mendapatkan struktur tabel arsip\n";
            }
        }
    } else {
        echo "   Gagal mendapatkan daftar tabel\n";
    }
} else {
    echo "Koneksi gagal, test dihentikan.\n";
}

echo "\n=== SELESAI ===\n";
?>
