<?php
echo "<h1>🖨️ TEST FITUR CETAK YANG BARU</h1>";
echo "<p><em>Testing fitur cetak yang diambil dari peminjaman-berkas-merged-ext-search</em></p>";

echo "<div style='background:#d1ecf1;padding:15px;border:1px solid #bee5eb;border-radius:5px;margin:20px 0;'>";
echo "<h3>✅ FITUR CETAK TERBARU</h3>";
echo "<p>✅ <strong>2 Halaman:</strong> Tanda Terima + Formulir Peminjaman</p>";
echo "<p>✅ <strong>Layout Profesional:</strong> Times New Roman, spacing optimal</p>";
echo "<p>✅ <strong>Tanda Tangan:</strong> 3 kolom (Ketua, Panitera, Panmud) + Pemohon</p>";
echo "<p>✅ <strong>Auto Print:</strong> Langsung muncul dialog cetak</p>";
echo "<p>✅ <strong>Responsive:</strong> Menyesuaikan ukuran kertas A4</p>";
echo "</div>";

require 'db.php';

try {
    // Get sample data
    $stmt = $db->query("SELECT * FROM peminjaman LIMIT 5");
    $data = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "<h3>📋 TEST DATA PEMINJAMAN:</h3>";
    echo "<table border='1' style='border-collapse:collapse;width:100%;'>";
    echo "<tr style='background:#f8f9fa;'>";
    echo "<th style='padding:8px;'>ID</th>";
    echo "<th style='padding:8px;'>Nama</th>";
    echo "<th style='padding:8px;'>Nomor Perkara</th>";
    echo "<th style='padding:8px;'>Status</th>";
    echo "<th style='padding:8px;'>Action</th>";
    echo "</tr>";
    
    foreach ($data as $row) {
        echo "<tr>";
        echo "<td style='padding:8px;text-align:center;'>{$row['id']}</td>";
        echo "<td style='padding:8px;'>" . htmlspecialchars($row['nama']) . "</td>";
        echo "<td style='padding:8px;'>" . htmlspecialchars($row['nomor_perkara']) . "</td>";
        echo "<td style='padding:8px;text-align:center;'>";
        if ($row['status'] === 'pinjam') {
            echo "<span style='background:#ffc107;padding:2px 8px;border-radius:3px;'>PINJAM</span>";
        } else {
            echo "<span style='background:#28a745;padding:2px 8px;border-radius:3px;color:white;'>KEMBALI</span>";
        }
        echo "</td>";
        echo "<td style='padding:8px;text-align:center;'>";
        echo "<a href='print.php?id={$row['id']}' target='_blank' style='background:#007bff;color:white;padding:5px 10px;text-decoration:none;border-radius:3px;'>🖨️ CETAK</a>";
        echo "</td>";
        echo "</tr>";
    }
    
    echo "</table>";
    
} catch (Exception $e) {
    echo "<p style='color:red;'>❌ Error: " . $e->getMessage() . "</p>";
}

echo "<div style='background:#fff3cd;padding:15px;border:1px solid #ffeaa7;border-radius:5px;margin:20px 0;'>";
echo "<h3>📝 PERUBAHAN FITUR CETAK:</h3>";
echo "<h4>🔄 SEBELUM (print.php lama):</h4>";
echo "<ul>";
echo "<li>❌ 1 halaman saja</li>";
echo "<li>❌ Layout sederhana</li>";
echo "<li>❌ Tanda tangan kurang profesional</li>";
echo "</ul>";

echo "<h4>✅ SEKARANG (print.php baru dari ext-search):</h4>";
echo "<ul>";
echo "<li>✅ <strong>2 Halaman:</strong> Tanda Terima + Formulir</li>";
echo "<li>✅ <strong>Layout Profesional:</strong> Header dengan kop surat, tabel rapi</li>";
echo "<li>✅ <strong>Tanda Tangan Lengkap:</strong> Ketua, Panitera, Panmud Hukum, Pemohon</li>";
echo "<li>✅ <strong>Auto Print:</strong> window.print() otomatis</li>";
echo "<li>✅ <strong>Responsive Print:</strong> @page A4 margin 2cm</li>";
echo "</ul>";
echo "</div>";

echo "<div style='background:#d4edda;padding:15px;border:1px solid #c3e6cb;border-radius:5px;margin:20px 0;'>";
echo "<h3>🎯 QUICK ACCESS</h3>";
echo "<div style='display:flex;gap:10px;flex-wrap:wrap;'>";
echo "<a href='index.php' style='padding:10px 15px;background:#28a745;color:white;text-decoration:none;border-radius:5px;'>🏠 Dashboard</a>";
echo "<a href='print.php?id=1' target='_blank' style='padding:10px 15px;background:#007bff;color:white;text-decoration:none;border-radius:5px;'>🖨️ Test Print ID 1</a>";
echo "<a href='recovery-complete.php' style='padding:10px 15px;background:#17a2b8;color:white;text-decoration:none;border-radius:5px;'>📋 Recovery Status</a>";
echo "</div>";
echo "</div>";

echo "<hr>";
echo "<h2 style='text-align:center;color:#007bff;'>🖨️ FITUR CETAK BERHASIL DIPERBAHARUI! 🖨️</h2>";
echo "<p style='text-align:center;'><em>Klik tombol 'CETAK' pada tabel di atas untuk test fitur cetak baru</em></p>";
echo "<p style='text-align:center;font-size:12px;color:#666;'>Updated at: " . date('Y-m-d H:i:s') . " WITA</p>";
?>
