<?php
echo "<h1>⚙️ TEST FITUR ADMIN PENGATURAN PEJABAT</h1>";
echo "<p><em>Testing fitur admin yang diambil dari peminjaman-berkas-merged-admin</em></p>";

echo "<div style='background:#d1ecf1;padding:15px;border:1px solid #bee5eb;border-radius:5px;margin:20px 0;'>";
echo "<h3>✅ FITUR ADMIN TERBARU</h3>";
echo "<p>✅ <strong>4 Pejabat:</strong> Ketua PN, Wakil Ketua, Panitera, Panmud Hukum</p>";
echo "<p>✅ <strong>Pratinjau Tanda Tangan:</strong> Preview visual yang bagus</p>";
echo "<p>✅ <strong>UI Bootstrap:</strong> Clean, profesional dengan Bootstrap 5</p>";
echo "<p>✅ <strong>Integrasi Print:</strong> Nama pejabat otomatis muncul di cetak</p>";
echo "<p>✅ <strong>Validasi Form:</strong> Required fields dan error handling</p>";
echo "</div>";

require 'db.php';

try {
    // Get current settings
    $ketua = setting_get('ketua_nama', 'Belum diatur');
    $wakil = setting_get('wakil_nama', 'Belum diatur');
    $panitera = setting_get('panitera_nama', 'Belum diatur');
    $panmud = setting_get('panmud_nama', 'Belum diatur');
    
    echo "<h3>👥 DATA PEJABAT SAAT INI:</h3>";
    echo "<table border='1' style='border-collapse:collapse;width:100%;'>";
    echo "<tr style='background:#f8f9fa;'>";
    echo "<th style='padding:8px;'>Jabatan</th>";
    echo "<th style='padding:8px;'>Nama</th>";
    echo "</tr>";
    
    $pejabat = [
        'Ketua PN Watampone' => $ketua,
        'Wakil Ketua PN' => $wakil,
        'Panitera' => $panitera,
        'Panmud Hukum' => $panmud
    ];
    
    foreach ($pejabat as $jabatan => $nama) {
        $status = ($nama === 'Belum diatur') ? 'danger' : 'success';
        $icon = ($nama === 'Belum diatur') ? '❌' : '✅';
        
        echo "<tr>";
        echo "<td style='padding:8px;'><strong>$jabatan</strong></td>";
        echo "<td style='padding:8px;'>";
        echo "<span style='background:" . ($status === 'danger' ? '#f8d7da' : '#d4edda') . ";padding:2px 8px;border-radius:3px;'>";
        echo "$icon " . htmlspecialchars($nama);
        echo "</span>";
        echo "</td>";
        echo "</tr>";
    }
    
    echo "</table>";
    
} catch (Exception $e) {
    echo "<p style='color:red;'>❌ Error: " . $e->getMessage() . "</p>";
}

echo "<div style='background:#fff3cd;padding:15px;border:1px solid #ffeaa7;border-radius:5px;margin:20px 0;'>";
echo "<h3>📝 PERUBAHAN FITUR ADMIN:</h3>";
echo "<h4>🔄 SEBELUM (admin.php lama):</h4>";
echo "<ul>";
echo "<li>❌ Hanya 2 pejabat (Ketua & Wakil Ketua)</li>";
echo "<li>❌ Tidak ada pratinjau tanda tangan</li>";
echo "<li>❌ UI kurang profesional</li>";
echo "</ul>";

echo "<h4>✅ SEKARANG (admin.php dari merged-admin):</h4>";
echo "<ul>";
echo "<li>✅ <strong>4 Pejabat Lengkap:</strong> Ketua, Wakil, Panitera, Panmud</li>";
echo "<li>✅ <strong>Pratinjau Visual:</strong> Preview tanda tangan dalam 4 kotak</li>";
echo "<li>✅ <strong>UI Bootstrap Modern:</strong> Card layout, responsive design</li>";
echo "<li>✅ <strong>Integrasi Print:</strong> Nama otomatis muncul di cetak</li>";
echo "<li>✅ <strong>Validasi Lengkap:</strong> Required fields, error handling</li>";
echo "</ul>";
echo "</div>";

echo "<div style='background:#d4edda;padding:15px;border:1px solid #c3e6cb;border-radius:5px;margin:20px 0;'>";
echo "<h3>🎯 QUICK ACCESS</h3>";
echo "<div style='display:flex;gap:10px;flex-wrap:wrap;'>";
echo "<a href='admin.php' style='padding:10px 15px;background:#007bff;color:white;text-decoration:none;border-radius:5px;'>⚙️ Pengaturan Pejabat</a>";
echo "<a href='index.php' style='padding:10px 15px;background:#28a745;color:white;text-decoration:none;border-radius:5px;'>🏠 Dashboard</a>";
echo "<a href='print.php?id=1' target='_blank' style='padding:10px 15px;background:#17a2b8;color:white;text-decoration:none;border-radius:5px;'>🖨️ Test Print</a>";
echo "<a href='recovery-complete.php' style='padding:10px 15px;background:#6f42c1;color:white;text-decoration:none;border-radius:5px;'>📋 Recovery Status</a>";
echo "</div>";
echo "</div>";

echo "<div style='background:#f8d7da;padding:15px;border:1px solid #f5c6cb;border-radius:5px;margin:20px 0;'>";
echo "<h3>🔧 CARA PENGGUNAAN:</h3>";
echo "<ol>";
echo "<li><strong>Akses Admin:</strong> Login sebagai admin (admin/admin123)</li>";
echo "<li><strong>Buka Pengaturan:</strong> Klik menu 'Admin Settings' atau tombol di atas</li>";
echo "<li><strong>Isi Data Pejabat:</strong> Masukkan nama lengkap dengan gelar</li>";
echo "<li><strong>Lihat Pratinjau:</strong> Scroll ke bawah untuk melihat preview tanda tangan</li>";
echo "<li><strong>Simpan:</strong> Klik tombol 'Simpan' untuk menyimpan perubahan</li>";
echo "<li><strong>Test Print:</strong> Coba cetak surat untuk melihat nama pejabat muncul</li>";
echo "</ol>";
echo "</div>";

echo "<hr>";
echo "<h2 style='text-align:center;color:#007bff;'>⚙️ FITUR ADMIN BERHASIL DIPERBAHARUI! ⚙️</h2>";
echo "<p style='text-align:center;'><em>Admin settings sekarang lebih lengkap dengan 4 pejabat dan pratinjau visual</em></p>";
echo "<p style='text-align:center;font-size:12px;color:#666;'>Updated at: " . date('Y-m-d H:i:s') . " WITA</p>";
?>
