<?php require 'auth.php'; require_login(); ?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Contoh Autocomplete Nomor Perkara</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
</head>
<body>
    <div class="container mt-4">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header bg-success text-white">
                        <h5 class="mb-0"><i class="fa fa-search me-2"></i>Autocomplete Nomor Perkara dari Arsip SIPP</h5>
                    </div>
                    <div class="card-body">
                        <div class="alert alert-info">
                            <i class="fa fa-info-circle me-2"></i>
                            <strong>Cara Penggunaan:</strong><br>
                            1. Ketik minimal 2 karakter pada field nomor perkara<br>
                            2. Pilih dari dropdown suggestion yang muncul<br>
                            3. Data akan otomatis terisi berdasarkan arsip SIPP
                        </div>
                        
                        <form>
                            <div class="row mb-3">
                                <div class="col-md-6">
                                    <label for="nomor_perkara" class="form-label">Nomor Perkara <span class="text-danger">*</span></label>
                                    <input type="text" class="form-control" id="nomor_perkara" name="nomor_perkara" 
                                           placeholder="contoh: 123/Pid.B/2025/PN.Wtp" autocomplete="off">
                                    <div class="form-text">Ketik untuk mencari di database arsip SIPP</div>
                                </div>
                                <div class="col-md-6">
                                    <label for="nomor_arsip" class="form-label">Nomor Arsip</label>
                                    <input type="text" class="form-control" id="nomor_arsip" name="nomor_arsip" readonly>
                                </div>
                            </div>
                            
                            <div class="row mb-3">
                                <div class="col-md-3">
                                    <label for="no_ruang" class="form-label">No. Ruang</label>
                                    <input type="text" class="form-control" id="no_ruang" name="no_ruang" readonly>
                                </div>
                                <div class="col-md-3">
                                    <label for="no_lemari" class="form-label">No. Lemari</label>
                                    <input type="text" class="form-control" id="no_lemari" name="no_lemari" readonly>
                                </div>
                                <div class="col-md-3">
                                    <label for="no_rak" class="form-label">No. Rak</label>
                                    <input type="text" class="form-control" id="no_rak" name="no_rak" readonly>
                                </div>
                                <div class="col-md-3">
                                    <label for="no_berkas" class="form-label">No. Berkas</label>
                                    <input type="text" class="form-control" id="no_berkas" name="no_berkas" readonly>
                                </div>
                            </div>
                            
                            <div id="selected-info" class="alert alert-success" style="display: none;">
                                <h6><i class="fa fa-check-circle me-2"></i>Data Arsip Ditemukan:</h6>
                                <div id="info-content"></div>
                            </div>
                            
                            <div class="d-flex gap-2">
                                <button type="submit" class="btn btn-primary">
                                    <i class="fa fa-save me-1"></i>Simpan
                                </button>
                                <button type="button" class="btn btn-secondary" onclick="clearForm()">
                                    <i class="fa fa-times me-1"></i>Clear
                                </button>
                            </div>
                        </form>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="js/nomor-perkara-autocomplete.js"></script>
    <script>
        document.addEventListener('DOMContentLoaded', function() {
            // Initialize autocomplete
            const autocomplete = new NomorPerkaraAutocomplete('#nomor_perkara', {
                onSelect: function(data) {
                    // Fill other form fields
                    document.getElementById('nomor_arsip').value = data.nomor_arsip || '';
                    document.getElementById('no_ruang').value = data.no_ruang || '';
                    document.getElementById('no_lemari').value = data.no_lemari || '';
                    document.getElementById('no_rak').value = data.no_rak || '';
                    document.getElementById('no_berkas').value = data.no_berkas || '';
                    
                    // Show info
                    const lokasi = `Ruang ${data.no_ruang || '-'}, Lemari ${data.no_lemari || '-'}, Rak ${data.no_rak || '-'}, Berkas ${data.no_berkas || '-'}`;
                    document.getElementById('info-content').innerHTML = `
                        <strong>Nomor Perkara:</strong> ${data.nomor_perkara}<br>
                        <strong>Nomor Arsip:</strong> ${data.nomor_arsip || '-'}<br>
                        <strong>Lokasi:</strong> ${lokasi}
                    `;
                    document.getElementById('selected-info').style.display = 'block';
                }
            });
        });
        
        function clearForm() {
            document.querySelector('form').reset();
            document.getElementById('selected-info').style.display = 'none';
        }
    </script>
</body>
</html>
