# Navigation Map - Sistem Peminjaman Berkas PN Watampone

## Site Map / Navigation Flow

```plantuml
@startuml
!theme plain
title Navigation Map - Sistem Peminjaman Berkas PN Watampone

skinparam rectangle {
    BackgroundColor lightblue
    BorderColor darkblue
    FontSize 11
}

rectangle "Login" as Login
rectangle "Dashboard" as Dashboard

Login --> Dashboard

rectangle "Data Peminjaman" as DataPeminjaman
rectangle "Arsip SIPP" as ArsipSIPP  
rectangle "Laporan" as Laporan
rectangle "Admin Panel" as AdminPanel

Dashboard --> DataPeminjaman
Dashboard --> ArsipSIPP
Dashboard --> Laporan  
Dashboard --> AdminPanel

' Data Peminjaman Sub-menu
rectangle "Form Tambah\nPeminjaman" as FormTambah
rectangle "Edit Data\nPeminjaman" as EditData
rectangle "Perpanjangan\nPeminjaman" as Perpanjangan
rectangle "Pengembalian\nBerkas" as Pengembalian
rectangle "Cetak Surat\nPeminjaman" as CetakSurat
rectangle "Cetak Bukti\nPengembalian" as CetakBukti

DataPeminjaman --> FormTambah
DataPeminjaman --> EditData
DataPeminjaman --> Perpanjangan
DataPeminjaman --> Pengembalian
DataPeminjaman --> CetakSurat
DataPeminjaman --> CetakBukti

' Arsip SIPP Sub-menu
rectangle "Arsip Online\n(SIPP Server)" as ArsipOnline
rectangle "Arsip Lokal\n(SQLite)" as ArsipLokal
rectangle "Sinkronisasi\nData" as SinkronData
rectangle "Import Data\nCSV" as ImportCSV

ArsipSIPP --> ArsipOnline
ArsipSIPP --> ArsipLokal
ArsipSIPP --> SinkronData
ArsipSIPP --> ImportCSV

' Laporan Sub-menu
rectangle "Laporan\nPeminjaman" as LaporanPeminjaman
rectangle "Statistik\nDashboard" as StatistikDashboard
rectangle "Notifikasi\nKeterlambatan" as NotifikasiTelat

Laporan --> LaporanPeminjaman
Laporan --> StatistikDashboard
Laporan --> NotifikasiTelat

' Admin Panel Sub-menu
rectangle "Manajemen\nUser" as ManajemenUser
rectangle "Pengaturan\nPejabat" as PengaturanPejabat
rectangle "Backup &\nRestore" as BackupRestore
rectangle "Ganti\nPassword" as GantiPassword

AdminPanel --> ManajemenUser
AdminPanel --> PengaturanPejabat
AdminPanel --> BackupRestore
AdminPanel --> GantiPassword

' Logout dari Dashboard
rectangle "Logout" as Logout
Dashboard --> Logout

@enduml
```

## Struktur Navigasi

### 🔐 **Login Page**
- Form login dengan username/password
- Redirect ke Dashboard setelah berhasil login

### 🏠 **Dashboard (Halaman Utama)**
Menu utama dengan 4 kategori besar:

#### 📋 **1. Data Peminjaman**
- **Form Tambah Peminjaman** - Input peminjaman baru dengan autocomplete
- **Edit Data Peminjaman** - Ubah data (admin only)
- **Perpanjangan Peminjaman** - Extend masa pinjam
- **Pengembalian Berkas** - Proses return berkas
- **Cetak Surat Peminjaman** - Print surat resmi
- **Cetak Bukti Pengembalian** - Print bukti dengan QR code

#### 📁 **2. Arsip SIPP**
- **Arsip Online (SIPP Server)** - Akses database server 192.168.1.240
- **Arsip Lokal (SQLite)** - Database backup lokal
- **Sinkronisasi Data** - Sync SIPP ke SQLite
- **Import Data CSV** - Import alternatif jika server down

#### 📊 **3. Laporan**
- **Laporan Peminjaman** - Report dengan filter periode
- **Statistik Dashboard** - Grafik dan angka statistik
- **Notifikasi Keterlambatan** - Alert berkas terlambat

#### ⚙️ **4. Admin Panel** (Admin Only)
- **Manajemen User** - CRUD user accounts
- **Pengaturan Pejabat** - Setting nama untuk tanda tangan
- **Backup & Restore** - Database management
- **Ganti Password** - Change password

### 🚪 **Logout**
- Keluar dari sistem dan kembali ke halaman login

## Flow Navigasi Utama

```
Login → Dashboard → [Menu Utama] → [Sub Menu] → [Action/Form]
  ↓         ↓            ↓            ↓           ↓
 Auth   Main Menu   Categories   Functions   Operations
```

## User Access Levels

### 👤 **Petugas**
Akses: Dashboard + Data Peminjaman + Arsip + Laporan

### 👨‍💼 **Admin** 
Akses: Semua menu + Admin Panel (full control)

## Penjelasan Navigation Map

Navigation Map merupakan representasi visual dari alur navigasi aplikasi yang menggambarkan hubungan antarhalaman dan fitur utama yang tersedia. Pada Aplikasi Sistem Peminjaman Berkas PN Watampone, alur dimulai dari Login menuju Dashboard sebagai halaman utama, kemudian dari Dashboard pengguna dapat mengakses empat menu utama yaitu Data Peminjaman, Arsip SIPP, Laporan, dan Admin Panel. Menu Data Peminjaman berisi sub-menu Form Tambah Peminjaman, Edit Data Peminjaman, Perpanjangan Peminjaman, Pengembalian Berkas, Cetak Surat Peminjaman, dan Cetak Bukti Pengembalian yang berkaitan dengan operasional peminjaman berkas perkara sehari-hari. Menu Arsip SIPP menampilkan fitur pengelolaan data arsip meliputi Arsip Online (SIPP Server), Arsip Lokal (SQLite), Sinkronisasi Data, dan Import Data CSV untuk mengintegrasikan sistem dengan database arsip perkara yang ada. Menu Laporan berisi fitur monitoring seperti Laporan Peminjaman, Statistik Dashboard, dan Notifikasi Keterlambatan yang membantu pengawasan dan evaluasi peminjaman berkas. Menu Admin Panel khusus administrator mencakup Manajemen User, Pengaturan Pejabat, Backup & Restore, dan Ganti Password untuk mengelola sistem secara keseluruhan, serta terdapat fitur Logout untuk keluar dari sistem dengan aman.

## Copy Kode Navigation Map:
