<?php
session_start();
require 'db.php';

// Simulate admin login for testing
if (!isset($_SESSION['user_id'])) {
    $_SESSION['user_id'] = 1;
    $_SESSION['username'] = 'admin';
    $_SESSION['role'] = 'admin';
}

echo "<h1>Direct Delete Test</h1>";

if (isset($_POST['do_delete'])) {
    echo "<h2>Attempting to delete all data...</h2>";
    
    try {
        $countBefore = $db->query("SELECT COUNT(*) FROM peminjaman")->fetchColumn();
        echo "<p>Records before: $countBefore</p>";
        
        $deleted = $db->exec("DELETE FROM peminjaman");
        
        $countAfter = $db->query("SELECT COUNT(*) FROM peminjaman")->fetchColumn();
        echo "<p>Records deleted: $deleted</p>";
        echo "<p>Records after: $countAfter</p>";
        
        if ($deleted > 0) {
            echo "<p style='color: green; font-weight: bold;'>✅ DELETE SUCCESSFUL!</p>";
        } else {
            echo "<p style='color: orange;'>⚠️ No records were deleted (table was already empty)</p>";
        }
        
    } catch (Exception $e) {
        echo "<p style='color: red;'>❌ Error: " . $e->getMessage() . "</p>";
    }
} else {
    // Show current state
    try {
        $count = $db->query("SELECT COUNT(*) FROM peminjaman")->fetchColumn();
        echo "<p>Current records in database: <strong>$count</strong></p>";
        
        if ($count > 0) {
            echo "<form method='POST'>";
            echo "<button type='submit' name='do_delete' onclick='return confirm(\"Delete all $count records?\")' style='background: red; color: white; padding: 10px; border: none; font-size: 16px;'>DELETE ALL DATA NOW</button>";
            echo "</form>";
        } else {
            echo "<p>No data to delete</p>";
        }
    } catch (Exception $e) {
        echo "<p style='color: red;'>Error: " . $e->getMessage() . "</p>";
    }
}

echo "<hr>";
echo "<a href='backup-restore.php'>Back to Backup Restore</a><br>";
echo "<a href='index.php'>Back to Main Page</a>";
?>
