<?php
require 'db.php';
require 'auth.php';
require_login();
require_admin();

echo "<h1>Debug Form Submission</h1>";

// Debug POST data
echo "<h2>POST Data:</h2>";
echo "<pre>";
print_r($_POST);
echo "</pre>";

// Debug current user
echo "<h2>Current User:</h2>";
echo "<pre>";
print_r(current_user());
echo "</pre>";

// Test form processing
if (isset($_POST['test_submit'])) {
    echo "<h2>Form Submitted Successfully!</h2>";
    echo "confirm_text: " . ($_POST['confirm_text'] ?? 'NOT SET') . "<br>";
    
    if (isset($_POST['confirm_text']) && $_POST['confirm_text'] === 'HAPUS SEMUA DATA') {
        echo "<p style='color: green;'>✅ Confirmation text matches!</p>";
        
        try {
            $count = $db->query("SELECT COUNT(*) FROM peminjaman")->fetchColumn();
            echo "Current record count: $count<br>";
            
            if ($count > 0) {
                // Actually delete for testing
                $deleted = $db->exec("DELETE FROM peminjaman");
                echo "<p style='color: red;'>🗑️ DELETED $deleted records!</p>";
                
                $newCount = $db->query("SELECT COUNT(*) FROM peminjaman")->fetchColumn();
                echo "New record count: $newCount<br>";
            } else {
                echo "No records to delete<br>";
            }
        } catch (Exception $e) {
            echo "Error: " . $e->getMessage();
        }
    } else {
        echo "<p style='color: red;'>❌ Confirmation text does not match</p>";
    }
}

// Get current count
$currentCount = 0;
try {
    $currentCount = $db->query("SELECT COUNT(*) FROM peminjaman")->fetchColumn();
} catch (Exception $e) {
    echo "Error getting count: " . $e->getMessage();
}
?>

<!DOCTYPE html>
<html>
<head>
    <title>Debug Form</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
</head>
<body>
    <div class="container mt-4">
        <div class="alert alert-info">
            Current records in database: <strong><?= $currentCount ?></strong>
        </div>
        
        <div class="card">
            <div class="card-header">
                <h3>Test Form</h3>
            </div>
            <div class="card-body">
                <form method="POST">
                    <div class="mb-3">
                        <label>Type "HAPUS SEMUA DATA" to confirm:</label>
                        <input type="text" name="confirm_text" class="form-control" required>
                    </div>
                    <button type="submit" name="test_submit" class="btn btn-danger">
                        Test Submit
                    </button>
                </form>
            </div>
        </div>
        
        <div class="mt-3">
            <a href="backup-restore.php" class="btn btn-secondary">Back to Backup Restore</a>
        </div>
    </div>
</body>
</html>
