<?php
require 'db.php';
require 'auth.php';
require_login();
require_admin();

echo "<h2>Debug Delete All Data</h2>";
echo "<h3>POST Data:</h3>";
echo "<pre>";
print_r($_POST);
echo "</pre>";

echo "<h3>Current Data Count:</h3>";
try {
    $count = $db->query("SELECT COUNT(*) FROM peminjaman")->fetchColumn();
    echo "Total records in peminjaman table: " . $count . "<br>";
    
    if ($count > 0) {
        echo "<h4>Sample Records:</h4>";
        $rows = $db->query("SELECT id, nomor_perkara, nama, status FROM peminjaman LIMIT 5")->fetchAll();
        foreach ($rows as $row) {
            echo "ID: {$row['id']}, Nomor: {$row['nomor_perkara']}, Nama: {$row['nama']}, Status: {$row['status']}<br>";
        }
    }
} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
}

if (isset($_POST['delete_all_data'])) {
    echo "<h3>Delete All Process:</h3>";
    echo "delete_all_data POST received<br>";
    echo "confirm_delete value: '" . ($_POST['confirm_delete'] ?? 'NOT SET') . "'<br>";
    
    if ($_POST['confirm_delete'] === 'HAPUS SEMUA DATA') {
        echo "Confirmation text matches!<br>";
        
        try {
            $deletedCount = $db->exec("DELETE FROM peminjaman");
            echo "Successfully deleted $deletedCount records<br>";
            
            $newCount = $db->query("SELECT COUNT(*) FROM peminjaman")->fetchColumn();
            echo "New record count: $newCount<br>";
        } catch (Exception $e) {
            echo "Error during delete: " . $e->getMessage() . "<br>";
        }
    } else {
        echo "Confirmation text does NOT match. Expected: 'HAPUS SEMUA DATA'<br>";
    }
}
?>

<hr>
<h3>Test Form:</h3>
<form method="POST">
    <input type="text" name="confirm_delete" placeholder="HAPUS SEMUA DATA" required><br><br>
    <button type="submit" name="delete_all_data">Test Delete All</button>
</form>

<p><a href="backup-restore.php">Back to Backup Restore</a></p>
