<?php
require 'db.php';

// Test untuk menampilkan struktur user dan memastikan kolom nama_lengkap ada
echo "<h3>Testing Fitur Username & Nama Lengkap</h3>";

try {
    // Check struktur tabel users
    $result = $db->query("PRAGMA table_info(users)");
    echo "<h4>Struktur Tabel Users:</h4>";
    echo "<table border='1'><tr><th>Column</th><th>Type</th><th>NotNull</th><th>Default</th></tr>";
    while ($row = $result->fetch(PDO::FETCH_ASSOC)) {
        echo "<tr><td>{$row['name']}</td><td>{$row['type']}</td><td>{$row['notnull']}</td><td>{$row['dflt_value']}</td></tr>";
    }
    echo "</table><br>";

    // Show all users
    $stmt = $db->query('SELECT id, username, nama_lengkap, role, created_at FROM users');
    $users = $stmt->fetchAll(PDO::FETCH_ASSOC);
    
    echo "<h4>Data Users:</h4>";
    echo "<table border='1'><tr><th>ID</th><th>Username</th><th>Nama Lengkap</th><th>Role</th><th>Created</th></tr>";
    foreach ($users as $user) {
        echo "<tr>";
        echo "<td>{$user['id']}</td>";
        echo "<td>{$user['username']}</td>";
        echo "<td>" . htmlspecialchars($user['nama_lengkap'] ?? 'Belum diset') . "</td>";
        echo "<td>{$user['role']}</td>";
        echo "<td>{$user['created_at']}</td>";
        echo "</tr>";
    }
    echo "</table><br>";

    echo "<h4>Penjelasan Fitur:</h4>";
    echo "<ol>";
    echo "<li><strong>Login menggunakan Username:</strong> User login dengan username seperti biasa</li>";
    echo "<li><strong>Tampil Nama Lengkap:</strong> Setelah login, yang ditampilkan adalah nama lengkap</li>";
    echo "<li><strong>Fallback:</strong> Jika nama lengkap kosong, akan menampilkan username</li>";
    echo "<li><strong>Database:</strong> Kolom nama_lengkap sudah ditambahkan ke tabel users</li>";
    echo "<li><strong>Form Management:</strong> Admin dapat mengelola username dan nama lengkap</li>";
    echo "</ol>";

} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
}
?>
