<?php
require 'db.php';

echo "<h1>Test Database After Seeding Removal</h1>";

try {
    // Check current count
    $count = $db->query('SELECT COUNT(*) FROM peminjaman')->fetchColumn();
    echo "<p>Current records: <strong>$count</strong></p>";
    
    if ($count > 0) {
        echo "<h2>Sample Records:</h2>";
        $rows = $db->query('SELECT id, nomor_perkara, nama, status FROM peminjaman LIMIT 5')->fetchAll();
        echo "<table border='1'>";
        echo "<tr><th>ID</th><th>Nomor Perkara</th><th>Nama</th><th>Status</th></tr>";
        foreach ($rows as $row) {
            echo "<tr><td>{$row['id']}</td><td>{$row['nomor_perkara']}</td><td>{$row['nama']}</td><td>{$row['status']}</td></tr>";
        }
        echo "</table>";
        
        // Test delete all
        echo "<h2>Delete All Test:</h2>";
        $deleted = $db->exec("DELETE FROM peminjaman");
        echo "<p>Records deleted: $deleted</p>";
        
        // Check count after delete
        $newCount = $db->query('SELECT COUNT(*) FROM peminjaman')->fetchColumn();
        echo "<p>Records after delete: <strong>$newCount</strong></p>";
        
        if ($newCount == 0) {
            echo "<p style='color: green;'>✅ SUCCESS: Database is completely empty!</p>";
            echo "<p style='color: green;'>✅ No automatic seeding occurred!</p>";
        } else {
            echo "<p style='color: red;'>❌ WARNING: $newCount records still exist or were re-added!</p>";
        }
    } else {
        echo "<p style='color: blue;'>ℹ️ Database is already empty</p>";
    }
    
} catch (Exception $e) {
    echo "<p style='color: red;'>Error: " . $e->getMessage() . "</p>";
}

echo "<hr>";
echo "<p><a href='index.php'>Back to Main Dashboard</a></p>";
echo "<p><a href='backup-restore.php'>Back to Backup & Restore</a></p>";
?>
