<?php require 'auth.php'; require_login(); ?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Test Autocomplete dengan Login</title>
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/css/bootstrap.min.css">
    <link rel="stylesheet" href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.5.2/css/all.min.css">
</head>
<body>
    <div class="container mt-4">
        <div class="row justify-content-center">
            <div class="col-md-8">
                <div class="card">
                    <div class="card-header bg-success text-white">
                        <h5 class="mb-0"><i class="fa fa-search me-2"></i>Test Autocomplete Nomor Perkara</h5>
                    </div>
                    <div class="card-body">
                        <div class="alert alert-info">
                            <i class="fa fa-info-circle me-2"></i>
                            Anda sudah login sebagai: <strong><?php echo $_SESSION['username'] ?? 'Unknown'; ?></strong>
                        </div>
                        
                        <div class="mb-3">
                            <label for="nomor_perkara" class="form-label">Nomor Perkara:</label>
                            <input type="text" class="form-control" id="nomor_perkara" name="nomor_perkara" 
                                   placeholder="Ketik untuk mencari nomor perkara..." autocomplete="off">
                            <div class="form-text">Mulai mengetik minimal 2 karakter untuk melihat saran.</div>
                        </div>
                        
                        <div class="alert alert-success d-none" id="selection-result">
                            <h6><i class="fa fa-check me-2"></i>Data Terpilih:</h6>
                            <div id="selected-data"></div>
                        </div>
                        
                        <div class="mt-3">
                            <button type="button" class="btn btn-secondary" onclick="clearInput()">
                                <i class="fa fa-times me-1"></i>Clear
                            </button>
                            <button type="button" class="btn btn-primary" onclick="testAPI()">
                                <i class="fa fa-cog me-1"></i>Test API Manual
                            </button>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.3/dist/js/bootstrap.bundle.min.js"></script>
    <script src="js/nomor-perkara-autocomplete.js"></script>
    <script>
        // Initialize autocomplete
        const autocomplete = new NomorPerkaraAutocomplete('#nomor_perkara', {
            onSelect: function(data) {
                console.log('Selected data:', data);
                
                // Show selected data
                const resultDiv = document.getElementById('selection-result');
                const dataDiv = document.getElementById('selected-data');
                
                dataDiv.innerHTML = `
                    <strong>Nomor Perkara:</strong> ${data.nomor_perkara}<br>
                    <strong>Nomor Arsip:</strong> ${data.nomor_arsip}<br>
                    <strong>Ruang:</strong> ${data.no_ruang}<br>
                    <strong>Lemari:</strong> ${data.no_lemari}<br>
                    <strong>Rak:</strong> ${data.no_rak}<br>
                    <strong>Berkas:</strong> ${data.no_berkas}
                `;
                
                resultDiv.classList.remove('d-none');
            }
        });
        
        function clearInput() {
            document.getElementById('nomor_perkara').value = '';
            document.getElementById('selection-result').classList.add('d-none');
        }
        
        async function testAPI() {
            const query = '123'; // Test query
            
            try {
                const response = await fetch(`api/search-nomor-perkara.php?q=${encodeURIComponent(query)}`);
                const data = await response.json();
                
                console.log('API Test Result:', data);
                
                if (Array.isArray(data) && data.length > 0) {
                    alert(`API Test Success! Found ${data.length} results.`);
                } else if (data.error) {
                    alert(`API Test Error: ${data.error}`);
                } else {
                    alert('API Test: No results found.');
                }
                
            } catch (error) {
                console.error('API Test Error:', error);
                alert(`API Test Failed: ${error.message}`);
            }
        }
        
        // Log when page is ready
        document.addEventListener('DOMContentLoaded', function() {
            console.log('Page loaded. Autocomplete initialized.');
        });
    </script>
</body>
</html>
