# FIX: Arsip Column Mapping Issue

## Problem
The archive table (Arsip SIPP) was not displaying data in the columns:
- Nomor Ruang
- Nomor Rak/Lemari  
- Nomor Tingkat/Laci
- Nomor Boks

## Root Cause
The column mapping in `arsip.php` was using incorrect column names that don't exist in the actual `arsip` table.

## Actual Database Structure
The `arsip` table in the SIPP database has these columns:
- `no_ruang` (not `nomor_ruang`)
- `no_lemari` (not `nomor_lemari` or `nomor_rak`)
- `no_rak` (this exists, but was mapped incorrectly)
- `no_berkas` (not `nomor_boks` or `nomor_tingkat`/`nomor_laci`)

## Solution Applied
Updated the column mapping in `arsip.php`:

### Before:
```php
<td><?= htmlspecialchars($row['nomor_ruang'] ?? '') ?></td>
<td><?= htmlspecialchars($row['nomor_rak'] ?? $row['nomor_lemari'] ?? '') ?></td>
<td><?= htmlspecialchars($row['nomor_tingkat'] ?? $row['nomor_laci'] ?? '') ?></td>
<td><?= htmlspecialchars($row['nomor_boks'] ?? '') ?></td>
```

### After:
```php
<td><?= htmlspecialchars($row['no_ruang'] ?? '') ?></td>
<td><?= htmlspecialchars($row['no_lemari'] ?? '') ?></td>
<td><?= htmlspecialchars($row['no_rak'] ?? '') ?></td>
<td><?= htmlspecialchars($row['no_berkas'] ?? '') ?></td>
```

### Also updated search functionality:
```php
// Changed search columns from nomor_ruang, nomor_rak to no_ruang, no_rak
$sql .= " AND (nomor_perkara LIKE ? OR nomor_arsip LIKE ? OR no_ruang LIKE ? OR no_rak LIKE ?)";
```

### And date field:
```php
// Changed from tanggal_masuk to tanggal_masuk_arsip
$tanggal = $row['tanggal_masuk_arsip'] ?? $row['tanggal_daftar'] ?? $row['created_at'] ?? '';
```

## Result
Now all archive columns display their correct data:
- **Nomor Ruang**: Shows `no_ruang` values (e.g., "01")
- **Nomor Rak/Lemari**: Shows `no_lemari` values (e.g., "01") 
- **Nomor Tingkat/Laci**: Shows `no_rak` values (e.g., "01")
- **Nomor Boks**: Shows `no_berkas` values (e.g., "01")

## Date Created
September 1, 2025

## Files Modified
- `arsip.php`: Updated column mapping and search functionality
