<?php
// Test sederhana untuk melihat isi tabel arsip
require 'auth.php';
require 'db.php';
require_login();

// Konfigurasi database SIPP
$sipp_config = [
    'host' => '192.168.1.240',
    'dbname' => 'sippbaco',
    'username' => 'pnwtp',
    'password' => 'pnwtp2019',
    'port' => 3306
];

echo "<h1>Test Isi Tabel Arsip SIPP</h1>";

try {
    $dsn = "mysql:host={$sipp_config['host']};port={$sipp_config['port']};dbname={$sipp_config['dbname']};charset=utf8mb4";
    $sipp_db = new PDO($dsn, $sipp_config['username'], $sipp_config['password']);
    $sipp_db->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    
    echo "<p style='color:green'>✓ Berhasil terhubung ke database SIPP</p>";
    
    // Cek struktur tabel arsip
    echo "<h2>Struktur Tabel Arsip:</h2>";
    $stmt = $sipp_db->query("DESCRIBE arsip");
    $columns = $stmt->fetchAll();
    
    echo "<table border='1' style='border-collapse:collapse'>";
    echo "<tr><th>Kolom</th><th>Type</th><th>Null</th><th>Key</th><th>Default</th></tr>";
    foreach($columns as $col) {
        echo "<tr>";
        echo "<td>{$col['Field']}</td>";
        echo "<td>{$col['Type']}</td>";
        echo "<td>{$col['Null']}</td>";
        echo "<td>{$col['Key']}</td>";
        echo "<td>{$col['Default']}</td>";
        echo "</tr>";
    }
    echo "</table>";
    
    // Hitung total data
    $stmt = $sipp_db->query("SELECT COUNT(*) as total FROM arsip");
    $total = $stmt->fetchColumn();
    echo "<h2>Total Data: {$total} record</h2>";
    
    if ($total > 0) {
        // Ambil 10 data pertama
        echo "<h2>Sample Data (10 record pertama):</h2>";
        $stmt = $sipp_db->query("SELECT * FROM arsip LIMIT 10");
        $data = $stmt->fetchAll();
        
        if (!empty($data)) {
            echo "<table border='1' style='border-collapse:collapse'>";
            // Header
            echo "<tr>";
            foreach(array_keys($data[0]) as $column) {
                echo "<th>{$column}</th>";
            }
            echo "</tr>";
            
            // Data
            foreach($data as $row) {
                echo "<tr>";
                foreach($row as $value) {
                    $display_value = strlen($value) > 50 ? substr($value, 0, 50) . '...' : $value;
                    echo "<td>" . htmlspecialchars($display_value) . "</td>";
                }
                echo "</tr>";
            }
            echo "</table>";
        }
    } else {
        echo "<p>Tabel arsip kosong</p>";
    }
    
} catch (PDOException $e) {
    echo "<p style='color:red'>✗ Error: " . $e->getMessage() . "</p>";
}
?>

<p><a href="arsip.php">← Kembali ke Arsip SIPP</a></p>
