<?php
// Konfigurasi Database untuk XAMPP

$config = [
    'host' => 'localhost',
    'database' => 'permohonan_salinan_putusan',
    'username' => 'root',
    'password' => ''
];

try {
    $pdo = new PDO(
        "mysql:host={$config['host']};dbname={$config['database']};charset=utf8mb4",
        $config['username'],
        $config['password'],
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
        ]
    );
    
    echo "✅ Koneksi database berhasil!<br>";
    echo "Database: " . $config['database'] . "<br>";
    echo "User: " . $config['username'] . "<br>";
    
} catch(PDOException $e) {
    echo "❌ Error koneksi database: " . $e->getMessage() . "<br>";
    echo "<br><strong>Troubleshooting:</strong><br>";
    echo "1. Pastikan database 'pnwy4699_permohonan' sudah dibuat<br>";
    echo "2. Pastikan user 'pnwy4699_dbuser' sudah dibuat<br>";
    echo "3. Pastikan user sudah di-assign ke database dengan privilege ALL<br>";
    echo "4. Pastikan password benar: 'permohonan-salinan-putusan'<br>";
}
?>
