<?php
// Test Database Connection
$config = [
    'host' => 'localhost',
    'username' => 'pnwy4699_dbuser',
    'password' => 'MyPass123!', // Ganti dengan password yang Anda buat di cPanel
    'database' => 'pnwy4699_permohonan'
];

try {
    $pdo = new PDO(
        "mysql:host={$config['host']};dbname={$config['database']};charset=utf8mb4",
        $config['username'],
        $config['password'],
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
        ]
    );
    
    echo "<h2>✅ KONEKSI DATABASE BERHASIL!</h2>";
    echo "<p><strong>Host:</strong> {$config['host']}</p>";
    echo "<p><strong>Database:</strong> {$config['database']}</p>";
    echo "<p><strong>Username:</strong> {$config['username']}</p>";
    echo "<p><strong>Status:</strong> Terhubung</p>";
    
    // Test query
    $stmt = $pdo->query("SHOW TABLES");
    $tables = $stmt->fetchAll(PDO::FETCH_COLUMN);
    
    echo "<h3>Tables dalam database:</h3>";
    if (empty($tables)) {
        echo "<p>⚠️ Belum ada tabel. Jalankan create_tables.php</p>";
    } else {
        echo "<ul>";
        foreach ($tables as $table) {
            echo "<li>$table</li>";
        }
        echo "</ul>";
    }
    
} catch (PDOException $e) {
    echo "<h2>❌ KONEKSI DATABASE GAGAL!</h2>";
    echo "<p><strong>Error:</strong> " . $e->getMessage() . "</p>";
    echo "<h3>Solusi:</h3>";
    echo "<ul>";
    echo "<li>Periksa password database di cPanel</li>";
    echo "<li>Pastikan user sudah di-assign ke database</li>";
    echo "<li>Pastikan database sudah dibuat</li>";
    echo "</ul>";
}
?>
