<?php
echo "<h2>🔧 Quick Database Setup untuk XAMPP</h2>";

try {
    // Koneksi ke MySQL
    $pdo = new PDO(
        "mysql:host=localhost;charset=utf8mb4",
        "root",
        "",
        [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
    );
    
    echo "<p>✅ Koneksi MySQL berhasil</p>";
    
    // Buat database
    $pdo->exec("CREATE DATABASE IF NOT EXISTS permohonan_salinan_putusan CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
    echo "<p>✅ Database 'permohonan_salinan_putusan' berhasil dibuat</p>";
    
    // Pilih database
    $pdo->exec("USE permohonan_salinan_putusan");
    
    // Buat tabel users
    $sql = "
    CREATE TABLE IF NOT EXISTS users (
        id INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
        username VARCHAR(100) NOT NULL,
        email VARCHAR(255) NOT NULL,
        password VARCHAR(255) NOT NULL,
        role ENUM('admin','petugas','pemohon') NOT NULL DEFAULT 'pemohon',
        is_active TINYINT(1) NOT NULL DEFAULT 0,
        email_verified_at DATETIME DEFAULT NULL,
        created_at DATETIME DEFAULT NULL,
        updated_at DATETIME DEFAULT NULL,
        PRIMARY KEY (id),
        UNIQUE KEY username (username),
        UNIQUE KEY email (email)
    ) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci";
    
    $pdo->exec($sql);
    echo "<p>✅ Tabel 'users' berhasil dibuat</p>";
    
    // Insert admin user
    $adminPassword = password_hash('password', PASSWORD_DEFAULT);
    $stmt = $pdo->prepare("
        INSERT INTO users (username, email, password, role, is_active, created_at, updated_at) 
        VALUES (?, ?, ?, 'admin', 1, NOW(), NOW())
        ON DUPLICATE KEY UPDATE password = ?
    ");
    $stmt->execute(['admin', 'admin@test.com', $adminPassword, $adminPassword]);
    echo "<p>✅ User admin berhasil dibuat</p>";
    
    // Tampilkan user yang ada
    $stmt = $pdo->query("SELECT id, username, email, role, is_active FROM users");
    $users = $stmt->fetchAll();
    
    echo "<h3>👥 Users yang tersedia:</h3>";
    echo "<table border='1' style='border-collapse: collapse; margin: 10px 0;'>";
    echo "<tr><th>ID</th><th>Username</th><th>Email</th><th>Role</th><th>Active</th></tr>";
    foreach ($users as $user) {
        echo "<tr>";
        echo "<td>{$user['id']}</td>";
        echo "<td>{$user['username']}</td>";
        echo "<td>{$user['email']}</td>";
        echo "<td>{$user['role']}</td>";
        echo "<td>" . ($user['is_active'] ? 'Yes' : 'No') . "</td>";
        echo "</tr>";
    }
    echo "</table>";
    
    echo "<h3>🔐 Login Credentials:</h3>";
    echo "<p><strong>Username:</strong> admin<br>";
    echo "<strong>Password:</strong> password</p>";
    
    echo "<h3>🔗 Test Links:</h3>";
    echo "<p><a href='public/login'>Login ke CodeIgniter 4</a></p>";
    echo "<p><a href='public/login.php'>Login Legacy</a></p>";
    
} catch (PDOException $e) {
    echo "<p style='color: red;'>❌ Error: " . $e->getMessage() . "</p>";
}
?>
