-- Database Setup Script FINAL untuk Permohonan Salinan Putusan
-- Script ini sesuai dengan struktur yang dibutuhkan aplikasi

-- Table: users
CREATE TABLE IF NOT EXISTS users (
    id INT AUTO_INCREMENT PRIMARY KEY,
    nama_lengkap VARCHAR(255) NOT NULL,
    username VARCHAR(100) UNIQUE NOT NULL,
    email VARCHAR(255) UNIQUE NOT NULL,
    password VARCHAR(255) NOT NULL,
    role ENUM('admin', 'user', 'pemohon') DEFAULT 'user',
    nomor_hp VARCHAR(20),
    alamat TEXT,
    is_active TINYINT(1) DEFAULT 1,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Table: pemohon_profiles
CREATE TABLE IF NOT EXISTS pemohon_profiles (
    id INT AUTO_INCREMENT PRIMARY KEY,
    user_id INT NOT NULL,
    nama_lengkap VARCHAR(255) NOT NULL,
    nik VARCHAR(20),
    no_telepon VARCHAR(20),
    tempat_lahir VARCHAR(100),
    tanggal_lahir DATE,
    jenis_kelamin ENUM('L', 'P'),
    pekerjaan VARCHAR(100),
    alamat_lengkap TEXT,
    kota VARCHAR(100),
    kode_pos VARCHAR(10),
    provinsi VARCHAR(100),
    status_verified ENUM('pending', 'verified', 'rejected') DEFAULT 'pending',
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (user_id) REFERENCES users(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Table: permohonans
CREATE TABLE IF NOT EXISTS permohonans (
    id INT AUTO_INCREMENT PRIMARY KEY,
    pemohon_id INT NOT NULL,
    kode_permohonan VARCHAR(20) UNIQUE NOT NULL,
    nomor_perkara VARCHAR(100) NOT NULL,
    tahun_perkara INT NOT NULL,
    para_pihak TEXT NOT NULL,
    jenis_perkara VARCHAR(50) NOT NULL,
    kebutuhan VARCHAR(100) NOT NULL,
    keperluan TEXT NOT NULL,
    status ENUM('pending', 'diproses', 'selesai', 'ditolak') DEFAULT 'pending',
    catatan TEXT,
    tanggal_selesai DATE NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    FOREIGN KEY (pemohon_id) REFERENCES users(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Table: permohonan_files
CREATE TABLE IF NOT EXISTS permohonan_files (
    id INT AUTO_INCREMENT PRIMARY KEY,
    permohonan_id INT NOT NULL,
    nama_file VARCHAR(255) NOT NULL,
    nama_asli VARCHAR(255) NOT NULL,
    file_path VARCHAR(500) NOT NULL,
    file_type VARCHAR(100) NOT NULL,
    file_size INT NOT NULL,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (permohonan_id) REFERENCES permohonans(id) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Table: system_settings
CREATE TABLE IF NOT EXISTS system_settings (
    id INT AUTO_INCREMENT PRIMARY KEY,
    setting_key VARCHAR(100) UNIQUE NOT NULL,
    setting_value TEXT,
    description TEXT,
    created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    updated_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- Insert default settings
INSERT IGNORE INTO system_settings (setting_key, setting_value, description) VALUES
('kop_surat_name', 'PENGADILAN NEGERI WATAMPONE', 'Nama instansi untuk kop surat'),
('kop_surat_address', 'Jl. Veteran No. 1 Watampone, Bone', 'Alamat instansi'),
('kop_surat_phone', 'Telp. (0481) 21234', 'Nomor telepon instansi'),
('max_file_size', '2048', 'Maksimal ukuran file upload dalam KB'),
('allowed_file_types', 'pdf,jpg,jpeg,png', 'Tipe file yang diizinkan'),
('app_name', 'Sistem Permohonan Salinan Putusan', 'Nama aplikasi'),
('app_version', '1.0.0', 'Versi aplikasi');

-- Insert demo users
INSERT IGNORE INTO users (nama_lengkap, username, email, password, role, nomor_hp, is_active) VALUES
('Administrator Demo', 'admin', 'admin@pn-watampone.go.id', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'admin', '081234567890', 1),
('Petugas Demo', 'petugas1', 'petugas1@pn-watampone.go.id', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'user', '081234567891', 1),
('Pemohon Demo', 'pemohon_demo', 'pemohon@example.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'pemohon', '081234567892', 1);

-- Insert sample pemohon profiles
INSERT IGNORE INTO pemohon_profiles (user_id, nama_lengkap, nik, no_telepon, tempat_lahir, tanggal_lahir, jenis_kelamin, pekerjaan, alamat_lengkap, kota, provinsi, status_verified) VALUES
(1, 'Administrator Demo', '7371234567890001', '081234567890', 'Watampone', '1980-01-01', 'L', 'PNS', 'Jl. Veteran No. 1', 'Watampone', 'Sulawesi Selatan', 'verified'),
(2, 'Petugas Demo', '7371234567890002', '081234567891', 'Watampone', '1985-02-15', 'P', 'PNS', 'Jl. Ahmad Yani No. 10', 'Watampone', 'Sulawesi Selatan', 'verified'),
(3, 'Pemohon Demo', '7371234567890003', '081234567892', 'Bone', '1990-03-20', 'L', 'Wiraswasta', 'Jl. Merdeka No. 25', 'Bone', 'Sulawesi Selatan', 'verified');

-- Insert sample permohonan data
INSERT IGNORE INTO permohonans (pemohon_id, kode_permohonan, nomor_perkara, tahun_perkara, para_pihak, jenis_perkara, kebutuhan, keperluan, status) VALUES
(3, 'PSP-2025-001', '123/Pdt.G/2025/PN Wtp', 2025, 'Ahmad vs Budi', 'Perdata', 'Salinan Putusan', 'Untuk keperluan banding', 'pending'),
(3, 'PSP-2025-002', '124/Pid.B/2025/PN Wtp', 2025, 'Negara vs Candra', 'Pidana', 'Salinan Putusan', 'Untuk keperluan kasasi', 'diproses');
