-- SKRIP LENGKAP PERBAIKAN DATABASE
-- Jalankan ini di phpMyAdmin untuk memperbaiki semua masalah

-- 1. Hapus dan buat ulang tabel permohonan_files
DROP TABLE IF EXISTS `permohonan_files`;

-- 2. Pastikan semua kolom yang diperlukan ada di tabel users
ALTER TABLE `users` 
ADD COLUMN IF NOT EXISTS `ktp_path` VARCHAR(500) NULL,
ADD COLUMN IF NOT EXISTS `role` ENUM('admin', 'user') DEFAULT 'user';

-- 3. Pastikan semua kolom yang diperlukan ada di tabel permohonans
ALTER TABLE `permohonans` 
ADD COLUMN IF NOT EXISTS `processed_at` TIMESTAMP NULL,
ADD COLUMN IF NOT EXISTS `keterangan` TEXT NULL;

-- 4. Buat ulang tabel permohonan_files dengan nama kolom yang benar
CREATE TABLE IF NOT EXISTS `permohonan_files` (
    `id` INT AUTO_INCREMENT PRIMARY KEY,
    `permohonan_id` INT NOT NULL,
    `file_name` VARCHAR(255) NOT NULL,
    `nama_asli` VARCHAR(255) NOT NULL,
    `file_path` VARCHAR(500) NOT NULL,
    `file_type` VARCHAR(100) NOT NULL,
    `file_size` INT NOT NULL,
    `created_at` TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
    FOREIGN KEY (`permohonan_id`) REFERENCES `permohonans`(`id`) ON DELETE CASCADE
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4;

-- 5. Update role untuk user demo yang sudah ada
UPDATE `users` SET `role` = 'admin' WHERE `email` = 'admin@test.com';
UPDATE `users` SET `role` = 'user' WHERE `email` = 'user@test.com';

-- 6. Insert data demo jika belum ada
INSERT IGNORE INTO `users` (`username`, `email`, `password`, `full_name`, `phone`, `address`, `role`) VALUES
('admin', 'admin@test.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'Administrator', '081234567890', 'Jl. Admin No. 1', 'admin'),
('user', 'user@test.com', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'User Demo', '081234567891', 'Jl. User No. 2', 'user');

-- 7. Insert sample permohonan
INSERT IGNORE INTO `permohonans` (`id`, `pemohon_id`, `jenis_permohonan`, `nomor_perkara`, `tanggal_permohonan`, `status`, `keterangan`) VALUES
(1, 2, 'Salinan Putusan', '123/Pdt.G/2023/PN.Wtp', '2023-01-01', 'pending', 'Permohonan salinan putusan untuk keperluan banding');

-- 8. Insert sample file
INSERT IGNORE INTO `permohonan_files` (`id`, `permohonan_id`, `file_name`, `nama_asli`, `file_path`, `file_type`, `file_size`) VALUES
(1, 1, 'sample_ktp.jpg', 'KTP_Pemohon.jpg', 'uploads/sample_ktp.jpg', 'image/jpeg', 102400);
