<?php
// Check if user is logged in and has petugas or admin role
if (!isLoggedIn() || !in_array(getUserRole(), ['petugas', 'admin'])) {
    redirect('?page=login');
}

// Handle verification actions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'] ?? '';
    $profileId = $_POST['profile_id'] ?? '';
    $reason = trim($_POST['reason'] ?? '');
    
    if (in_array($action, ['approve', 'reject']) && $profileId) {
        try {
            $pdo->beginTransaction();
            
            if ($action === 'approve') {
                // Approve user
                $stmt = $pdo->prepare("UPDATE pemohon_profiles SET status_verified = 'verified', verified_by = ?, verified_at = NOW(), updated_at = NOW() WHERE id = ?");
                $stmt->execute([$_SESSION['user_id'], $profileId]);
                
                // Activate user account
                $stmt = $pdo->prepare("UPDATE users u JOIN pemohon_profiles p ON u.id = p.user_id SET u.is_active = 1 WHERE p.id = ?");
                $stmt->execute([$profileId]);
                
                setFlashMessage('success', 'Akun pemohon berhasil diverifikasi');
            } else {
                // Reject user
                if (empty($reason)) {
                    throw new Exception('Alasan penolakan harus diisi');
                }
                
                $stmt = $pdo->prepare("UPDATE pemohon_profiles SET status_verified = 'rejected', verified_by = ?, verified_at = NOW(), rejection_reason = ?, updated_at = NOW() WHERE id = ?");
                $stmt->execute([$_SESSION['user_id'], $reason, $profileId]);
                
                setFlashMessage('success', 'Akun pemohon berhasil ditolak');
            }
            
            $pdo->commit();
        } catch (Exception $e) {
            $pdo->rollBack();
            setFlashMessage('error', 'Gagal memproses verifikasi: ' . $e->getMessage());
        }
    }
}

// Get pending verifications
$stmt = $pdo->query("
    SELECT p.*, u.username, u.email, u.created_at as registered_at 
    FROM pemohon_profiles p 
    JOIN users u ON u.id = p.user_id 
    WHERE p.status_verified = 'pending' 
    ORDER BY u.created_at ASC
");
$pendingVerifications = $stmt->fetchAll();

// Get all verifications (for history)
$stmt = $pdo->query("
    SELECT p.*, u.username, u.email, u.created_at as registered_at, 
           v.username as verified_by_name
    FROM pemohon_profiles p 
    JOIN users u ON u.id = p.user_id 
    LEFT JOIN users v ON v.id = p.verified_by
    WHERE p.status_verified IN ('verified', 'rejected')
    ORDER BY p.verified_at DESC 
    LIMIT 10
");
$verificationHistory = $stmt->fetchAll();

// Get statistics
$stmt = $pdo->query("
    SELECT 
        COUNT(*) as total,
        SUM(CASE WHEN status_verified = 'pending' THEN 1 ELSE 0 END) as pending,
        SUM(CASE WHEN status_verified = 'verified' THEN 1 ELSE 0 END) as verified,
        SUM(CASE WHEN status_verified = 'rejected' THEN 1 ELSE 0 END) as rejected
    FROM pemohon_profiles
");
$stats = $stmt->fetch();
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Verifikasi Akun Pemohon - Permohonan Salinan Putusan</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        .bg-primary-custom {
            background: linear-gradient(135deg, #1e3a8a, #3b82f6);
        }
        .card-custom {
            border: none;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        }
        .profile-card {
            border: 1px solid #e9ecef;
            border-radius: 10px;
            transition: all 0.3s ease;
        }
        .profile-card:hover {
            border-color: #007bff;
            box-shadow: 0 5px 15px rgba(0,123,255,0.1);
        }
        .ktp-thumbnail {
            max-width: 100px;
            max-height: 80px;
            object-fit: cover;
            border-radius: 5px;
            cursor: pointer;
        }
        .status-badge {
            font-size: 0.875rem;
            padding: 0.375rem 0.75rem;
            border-radius: 0.5rem;
        }
    </style>
</head>
<body class="bg-light">
    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary-custom">
        <div class="container">
            <a class="navbar-brand d-flex align-items-center" href="setup.php">
                <img src="/permohonan-salinan-putusan/gambar/Logo_pnwtp.png" alt="PN Watampone" height="35" class="me-2">
                <span>PN Watampone</span>
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav me-auto">
                    <li class="nav-item">
                        <a class="nav-link" href="?page=dashboard">
                            <i class="fas fa-tachometer-alt me-1"></i> Dashboard
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link active" href="?page=verifikasi">
                            <i class="fas fa-user-check me-1"></i> Verifikasi Akun
                        </a>
                    </li>
                </ul>
                
                <ul class="navbar-nav">
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown">
                            <i class="fas fa-user me-1"></i>
                            <?= htmlspecialchars($_SESSION['nama_lengkap']) ?>
                            <span class="badge bg-light text-dark ms-1"><?= ucfirst(getUserRole()) ?></span>
                        </a>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="?page=logout">
                                <i class="fas fa-sign-out-alt me-2"></i> Logout
                            </a></li>
                        </ul>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Main Content -->
    <main class="py-4">
        <div class="container-fluid">
            <!-- Header -->
            <div class="d-sm-flex align-items-center justify-content-between mb-4">
                <h1 class="h3 mb-0 text-gray-800">
                    <i class="fas fa-user-check me-2"></i>
                    Verifikasi Akun Pemohon
                </h1>
                <div class="d-sm-flex">
                    <span class="badge bg-primary px-3 py-2">
                        <i class="fas fa-calendar me-1"></i>
                        <?= date('d F Y, H:i') ?> WIB
                    </span>
                </div>
            </div>

            <!-- Flash Messages -->
            <?php if ($success = getFlashMessage('success')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <i class="fas fa-check-circle me-2"></i>
                    <?= htmlspecialchars($success) ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <?php if ($error = getFlashMessage('error')): ?>
                <div class="alert alert-danger alert-dismissible fade show" role="alert">
                    <i class="fas fa-exclamation-circle me-2"></i>
                    <?= htmlspecialchars($error) ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <!-- Statistics Cards -->
            <div class="row mb-4">
                <div class="col-xl-3 col-md-6 mb-3">
                    <div class="card border-left-primary h-100 py-2" style="border-left: 4px solid #007bff;">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col mr-2">
                                    <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                        Total Pemohon
                                    </div>
                                    <div class="h5 mb-0 font-weight-bold text-gray-800">
                                        <?= $stats['total'] ?>
                                    </div>
                                </div>
                                <div class="col-auto">
                                    <i class="fas fa-users fa-2x text-gray-300"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xl-3 col-md-6 mb-3">
                    <div class="card border-left-warning h-100 py-2" style="border-left: 4px solid #ffc107;">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col mr-2">
                                    <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                        Menunggu Verifikasi
                                    </div>
                                    <div class="h5 mb-0 font-weight-bold text-gray-800">
                                        <?= $stats['pending'] ?>
                                    </div>
                                </div>
                                <div class="col-auto">
                                    <i class="fas fa-clock fa-2x text-gray-300"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xl-3 col-md-6 mb-3">
                    <div class="card border-left-success h-100 py-2" style="border-left: 4px solid #28a745;">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col mr-2">
                                    <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                        Diverifikasi
                                    </div>
                                    <div class="h5 mb-0 font-weight-bold text-gray-800">
                                        <?= $stats['verified'] ?>
                                    </div>
                                </div>
                                <div class="col-auto">
                                    <i class="fas fa-check-circle fa-2x text-gray-300"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="col-xl-3 col-md-6 mb-3">
                    <div class="card border-left-danger h-100 py-2" style="border-left: 4px solid #dc3545;">
                        <div class="card-body">
                            <div class="row no-gutters align-items-center">
                                <div class="col mr-2">
                                    <div class="text-xs font-weight-bold text-danger text-uppercase mb-1">
                                        Ditolak
                                    </div>
                                    <div class="h5 mb-0 font-weight-bold text-gray-800">
                                        <?= $stats['rejected'] ?>
                                    </div>
                                </div>
                                <div class="col-auto">
                                    <i class="fas fa-times-circle fa-2x text-gray-300"></i>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Pending Verifications -->
            <div class="row">
                <div class="col-12">
                    <div class="card card-custom mb-4">
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                            <h6 class="m-0 font-weight-bold text-primary">
                                <i class="fas fa-clock me-2"></i>Menunggu Verifikasi (<?= count($pendingVerifications) ?>)
                            </h6>
                        </div>
                        <div class="card-body">
                            <?php if (empty($pendingVerifications)): ?>
                                <div class="text-center py-5">
                                    <i class="fas fa-check-circle fa-3x text-success mb-3"></i>
                                    <h5 class="text-muted">Semua akun sudah diverifikasi</h5>
                                    <p class="text-muted">Tidak ada akun pemohon yang menunggu verifikasi</p>
                                </div>
                            <?php else: ?>
                                <div class="row">
                                    <?php foreach ($pendingVerifications as $profile): ?>
                                        <div class="col-lg-6 col-xl-4 mb-4">
                                            <div class="profile-card p-4">
                                                <div class="d-flex align-items-start mb-3">
                                                    <div class="flex-shrink-0">
                                                        <div class="bg-warning text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 50px; height: 50px;">
                                                            <i class="fas fa-user fa-lg"></i>
                                                        </div>
                                                    </div>
                                                    <div class="flex-grow-1 ms-3">
                                                        <h6 class="mb-1"><?= htmlspecialchars($profile['nama_lengkap']) ?></h6>
                                                        <p class="mb-1 text-muted small"><?= htmlspecialchars($profile['email']) ?></p>
                                                        <span class="badge bg-warning status-badge">Pending</span>
                                                    </div>
                                                </div>
                                                
                                                <div class="row mb-3">
                                                    <div class="col-6">
                                                        <small class="text-muted">Username:</small><br>
                                                        <strong><?= htmlspecialchars($profile['username']) ?></strong>
                                                    </div>
                                                    <div class="col-6">
                                                        <small class="text-muted">NIK:</small><br>
                                                        <code><?= htmlspecialchars($profile['nik']) ?></code>
                                                    </div>
                                                </div>
                                                
                                                <div class="row mb-3">
                                                    <div class="col-12">
                                                        <small class="text-muted">No. Telepon:</small><br>
                                                        <strong><?= htmlspecialchars($profile['no_telepon']) ?></strong>
                                                    </div>
                                                </div>
                                                
                                                <div class="mb-3">
                                                    <small class="text-muted">Alamat:</small><br>
                                                    <span><?= htmlspecialchars($profile['alamat']) ?></span>
                                                </div>
                                                
                                                <?php if ($profile['ktp_path']): ?>
                                                    <div class="mb-3">
                                                        <small class="text-muted">File KTP:</small><br>
                                                        <button class="btn btn-sm btn-outline-info" onclick="viewKTP('<?= htmlspecialchars($profile['ktp_path']) ?>')">
                                                            <i class="fas fa-eye me-1"></i>Lihat KTP
                                                        </button>
                                                    </div>
                                                <?php endif; ?>
                                                
                                                <div class="mb-3">
                                                    <small class="text-muted">Tanggal Daftar:</small><br>
                                                    <span><?= date('d/m/Y H:i', strtotime($profile['registered_at'])) ?></span>
                                                </div>
                                                
                                                <div class="d-grid gap-2">
                                                    <button type="button" class="btn btn-success btn-sm" onclick="approveUser(<?= $profile['id'] ?>, '<?= htmlspecialchars($profile['nama_lengkap']) ?>')">
                                                        <i class="fas fa-check me-1"></i>Setujui
                                                    </button>
                                                    <button type="button" class="btn btn-danger btn-sm" onclick="rejectUser(<?= $profile['id'] ?>, '<?= htmlspecialchars($profile['nama_lengkap']) ?>')">
                                                        <i class="fas fa-times me-1"></i>Tolak
                                                    </button>
                                                </div>
                                            </div>
                                        </div>
                                    <?php endforeach; ?>
                                </div>
                            <?php endif; ?>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Verification History -->
            <?php if (!empty($verificationHistory)): ?>
            <div class="row">
                <div class="col-12">
                    <div class="card card-custom">
                        <div class="card-header py-3">
                            <h6 class="m-0 font-weight-bold text-primary">
                                <i class="fas fa-history me-2"></i>Riwayat Verifikasi (10 Terakhir)
                            </h6>
                        </div>
                        <div class="card-body">
                            <div class="table-responsive">
                                <table class="table table-hover">
                                    <thead>
                                        <tr>
                                            <th>Nama Pemohon</th>
                                            <th>Email</th>
                                            <th>NIK</th>
                                            <th>Status</th>
                                            <th>Diverifikasi Oleh</th>
                                            <th>Tanggal</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($verificationHistory as $history): ?>
                                            <tr>
                                                <td>
                                                    <strong><?= htmlspecialchars($history['nama_lengkap']) ?></strong><br>
                                                    <small class="text-muted"><?= htmlspecialchars($history['username']) ?></small>
                                                </td>
                                                <td><?= htmlspecialchars($history['email']) ?></td>
                                                <td><code><?= htmlspecialchars($history['nik']) ?></code></td>
                                                <td>
                                                    <?php if ($history['status_verified'] === 'verified'): ?>
                                                        <span class="badge bg-success status-badge">Verified</span>
                                                    <?php else: ?>
                                                        <span class="badge bg-danger status-badge">Rejected</span>
                                                    <?php endif; ?>
                                                </td>
                                                <td><?= htmlspecialchars($history['verified_by_name'] ?? 'N/A') ?></td>
                                                <td>
                                                    <small><?= date('d/m/Y H:i', strtotime($history['verified_at'])) ?></small>
                                                </td>
                                            </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
            <?php endif; ?>
        </div>
    </main>

    <!-- Approval Modal -->
    <div class="modal fade" id="approveModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header bg-success text-white">
                    <h5 class="modal-title">
                        <i class="fas fa-check-circle me-2"></i>Konfirmasi Persetujuan
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <form method="POST">
                    <div class="modal-body">
                        <p>Apakah Anda yakin ingin <strong>menyetujui</strong> akun pemohon:</p>
                        <div class="alert alert-info">
                            <strong id="approve-user-name"></strong>
                        </div>
                        <p>Setelah disetujui, pemohon dapat login dan menggunakan sistem.</p>
                        <input type="hidden" name="action" value="approve">
                        <input type="hidden" name="profile_id" id="approve-profile-id">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                        <button type="submit" class="btn btn-success">
                            <i class="fas fa-check me-1"></i>Ya, Setujui
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- Rejection Modal -->
    <div class="modal fade" id="rejectModal" tabindex="-1">
        <div class="modal-dialog">
            <div class="modal-content">
                <div class="modal-header bg-danger text-white">
                    <h5 class="modal-title">
                        <i class="fas fa-times-circle me-2"></i>Konfirmasi Penolakan
                    </h5>
                    <button type="button" class="btn-close btn-close-white" data-bs-dismiss="modal"></button>
                </div>
                <form method="POST">
                    <div class="modal-body">
                        <p>Apakah Anda yakin ingin <strong>menolak</strong> akun pemohon:</p>
                        <div class="alert alert-warning">
                            <strong id="reject-user-name"></strong>
                        </div>
                        <div class="mb-3">
                            <label for="reject-reason" class="form-label">Alasan Penolakan *</label>
                            <textarea class="form-control" id="reject-reason" name="reason" rows="3" placeholder="Masukkan alasan penolakan..." required></textarea>
                        </div>
                        <input type="hidden" name="action" value="reject">
                        <input type="hidden" name="profile_id" id="reject-profile-id">
                    </div>
                    <div class="modal-footer">
                        <button type="button" class="btn btn-secondary" data-bs-dismiss="modal">Batal</button>
                        <button type="submit" class="btn btn-danger">
                            <i class="fas fa-times me-1"></i>Ya, Tolak
                        </button>
                    </div>
                </form>
            </div>
        </div>
    </div>

    <!-- KTP Viewer Modal -->
    <div class="modal fade" id="ktpModal" tabindex="-1">
        <div class="modal-dialog modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">
                        <i class="fas fa-id-card me-2"></i>File KTP
                    </h5>
                    <button type="button" class="btn-close" data-bs-dismiss="modal"></button>
                </div>
                <div class="modal-body text-center">
                    <div id="ktp-content"></div>
                </div>
            </div>
        </div>
    </div>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        function approveUser(profileId, userName) {
            document.getElementById('approve-profile-id').value = profileId;
            document.getElementById('approve-user-name').textContent = userName;
            new bootstrap.Modal(document.getElementById('approveModal')).show();
        }

        function rejectUser(profileId, userName) {
            document.getElementById('reject-profile-id').value = profileId;
            document.getElementById('reject-user-name').textContent = userName;
            document.getElementById('reject-reason').value = '';
            new bootstrap.Modal(document.getElementById('rejectModal')).show();
        }

        function viewKTP(ktpPath) {
            const ktpContent = document.getElementById('ktp-content');
            const fileExtension = ktpPath.split('.').pop().toLowerCase();
            
            if (['jpg', 'jpeg', 'png'].includes(fileExtension)) {
                ktpContent.innerHTML = `<img src="../writable/uploads/${ktpPath}" class="img-fluid" alt="KTP">`;
            } else if (fileExtension === 'pdf') {
                ktpContent.innerHTML = `
                    <div class="alert alert-info">
                        <i class="fas fa-file-pdf me-2"></i>File PDF
                    </div>
                    <a href="../writable/uploads/${ktpPath}" target="_blank" class="btn btn-primary">
                        <i class="fas fa-external-link-alt me-1"></i>Buka PDF
                    </a>
                `;
            } else {
                ktpContent.innerHTML = `
                    <div class="alert alert-warning">
                        <i class="fas fa-exclamation-triangle me-2"></i>Format file tidak dapat ditampilkan
                    </div>
                `;
            }
            
            new bootstrap.Modal(document.getElementById('ktpModal')).show();
        }
    </script>
</body>
</html>
