<?php
// Handle AJAX requests for user management
if (!isLoggedIn() || !in_array(getUserRole(), ['admin', 'petugas'])) {
    exit('Unauthorized');
}

$action = $_GET['action'] ?? '';
$userId = $_GET['user_id'] ?? '';

if ($action === 'detail' && $userId) {
    // Get user detail
    $stmt = $pdo->prepare("
        SELECT u.*, p.nama_lengkap as profile_nama, p.nik, p.no_telepon, p.alamat, 
               p.tempat_lahir, p.tanggal_lahir, p.jenis_kelamin, p.pekerjaan, 
               p.status_verified, p.created_at as profile_created
        FROM users u 
        LEFT JOIN pemohon_profiles p ON p.user_id = u.id 
        WHERE u.id = ?
    ");
    $stmt->execute([$userId]);
    $user = $stmt->fetch();
    
    if (!$user) {
        echo '<div class="alert alert-danger">User tidak ditemukan</div>';
        exit;
    }
    ?>
    
    <div class="row">
        <div class="col-md-6">
            <h6 class="fw-bold">Informasi Akun</h6>
            <table class="table table-sm">
                <tr><td>ID</td><td><?= $user['id'] ?></td></tr>
                <tr><td>Username</td><td><?= htmlspecialchars($user['username']) ?></td></tr>
                <tr><td>Email</td><td><?= htmlspecialchars($user['email']) ?></td></tr>
                <tr><td>Role</td><td>
                    <span class="badge <?= 
                        $user['role'] === 'admin' ? 'bg-success' : 
                        ($user['role'] === 'petugas' ? 'bg-info' : 'bg-warning') 
                    ?>">
                        <?= ucfirst($user['role']) ?>
                    </span>
                </td></tr>
                <tr><td>Status</td><td>
                    <i class="fas fa-circle <?= $user['is_active'] ? 'text-success' : 'text-danger' ?>"></i>
                    <?= $user['is_active'] ? 'Aktif' : 'Nonaktif' ?>
                </td></tr>
                <tr><td>Terdaftar</td><td><?= date('d/m/Y H:i', strtotime($user['created_at'])) ?></td></tr>
            </table>
        </div>
        
        <div class="col-md-6">
            <h6 class="fw-bold">Profil Pemohon</h6>
            <?php if ($user['profile_nama']): ?>
            <table class="table table-sm">
                <tr><td>Nama Lengkap</td><td><?= htmlspecialchars($user['profile_nama']) ?></td></tr>
                <tr><td>NIK</td><td><?= htmlspecialchars($user['nik'] ?? '-') ?></td></tr>
                <tr><td>No. Telepon</td><td><?= htmlspecialchars($user['no_telepon'] ?? '-') ?></td></tr>
                <tr><td>Tempat Lahir</td><td><?= htmlspecialchars($user['tempat_lahir'] ?? '-') ?></td></tr>
                <tr><td>Tanggal Lahir</td><td><?= $user['tanggal_lahir'] ? date('d/m/Y', strtotime($user['tanggal_lahir'])) : '-' ?></td></tr>
                <tr><td>Jenis Kelamin</td><td><?= $user['jenis_kelamin'] === 'L' ? 'Laki-laki' : ($user['jenis_kelamin'] === 'P' ? 'Perempuan' : '-') ?></td></tr>
                <tr><td>Pekerjaan</td><td><?= htmlspecialchars($user['pekerjaan'] ?? '-') ?></td></tr>
                <tr><td>Status Verifikasi</td><td>
                    <span class="badge <?= 
                        $user['status_verified'] === 'verified' ? 'bg-success' : 
                        ($user['status_verified'] === 'pending' ? 'bg-warning' : 'bg-danger') 
                    ?>">
                        <?= ucfirst($user['status_verified']) ?>
                    </span>
                </td></tr>
            </table>
            <?php else: ?>
            <p class="text-muted">Profil belum dilengkapi</p>
            <?php endif; ?>
        </div>
    </div>
    
    <?php if ($user['alamat']): ?>
    <div class="mt-3">
        <h6 class="fw-bold">Alamat</h6>
        <p><?= nl2br(htmlspecialchars($user['alamat'])) ?></p>
    </div>
    <?php endif; ?>
    
    <?php
    exit;
}

if ($action === 'edit' && $userId) {
    // Get user for editing
    $stmt = $pdo->prepare("
        SELECT u.*, p.status_verified
        FROM users u 
        LEFT JOIN pemohon_profiles p ON p.user_id = u.id 
        WHERE u.id = ?
    ");
    $stmt->execute([$userId]);
    $user = $stmt->fetch();
    
    if (!$user) {
        echo '<div class="alert alert-danger">User tidak ditemukan</div>';
        exit;
    }
    ?>
    
    <input type="hidden" name="action" value="update_user">
    <input type="hidden" name="user_id" value="<?= $user['id'] ?>">
    
    <div class="mb-3">
        <label class="form-label">Status Akun</label>
        <select name="is_active" class="form-select">
            <option value="1" <?= $user['is_active'] ? 'selected' : '' ?>>Aktif</option>
            <option value="0" <?= !$user['is_active'] ? 'selected' : '' ?>>Nonaktif</option>
        </select>
    </div>
    
    <?php if (getUserRole() === 'admin'): ?>
    <div class="mb-3">
        <label class="form-label">Role</label>
        <select name="role" class="form-select">
            <option value="pemohon" <?= $user['role'] === 'pemohon' ? 'selected' : '' ?>>Pemohon</option>
            <option value="petugas" <?= $user['role'] === 'petugas' ? 'selected' : '' ?>>Petugas</option>
            <option value="admin" <?= $user['role'] === 'admin' ? 'selected' : '' ?>>Admin</option>
        </select>
    </div>
    <?php endif; ?>
    
    <?php if ($user['status_verified']): ?>
    <div class="mb-3">
        <label class="form-label">Status Verifikasi</label>
        <select name="status_verified" class="form-select">
            <option value="pending" <?= $user['status_verified'] === 'pending' ? 'selected' : '' ?>>Pending</option>
            <option value="verified" <?= $user['status_verified'] === 'verified' ? 'selected' : '' ?>>Verified</option>
            <option value="rejected" <?= $user['status_verified'] === 'rejected' ? 'selected' : '' ?>>Rejected</option>
        </select>
    </div>
    <?php endif; ?>
    
    <?php
    exit;
}

// Handle form submissions
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $action = $_POST['action'];
    $userId = $_POST['user_id'];
    
    if ($action === 'update_user' && $userId) {
        $success = false;
        
        // Update user status
        if (isset($_POST['is_active'])) {
            $stmt = $pdo->prepare("UPDATE users SET is_active = ? WHERE id = ?");
            $stmt->execute([$_POST['is_active'], $userId]);
            $success = true;
        }
        
        // Update role (admin only)
        if (isset($_POST['role']) && getUserRole() === 'admin') {
            $stmt = $pdo->prepare("UPDATE users SET role = ? WHERE id = ?");
            $stmt->execute([$_POST['role'], $userId]);
            $success = true;
        }
        
        // Update verification status
        if (isset($_POST['status_verified'])) {
            $stmt = $pdo->prepare("UPDATE pemohon_profiles SET status_verified = ? WHERE user_id = ?");
            $stmt->execute([$_POST['status_verified'], $userId]);
            $success = true;
        }
        
        if ($success) {
            echo '<script>
                alert("User berhasil diperbarui");
                window.location.href = "?page=kelola-user";
            </script>';
        } else {
            echo '<script>
                alert("Gagal memperbarui user");
                window.location.href = "?page=kelola-user";
            </script>';
        }
        exit;
    }
}
?>
