<?php
session_start();

# Helper functions
function redirect($url) {
    header("Location: $url");
    exit;
}

function getBaseUrl() {
    $protocol = isset($_SERVER['HTTPS']) && $_SERVER['HTTPS'] === 'on' ? 'https' : 'http';
    $host = $_SERVER['HTTP_HOST'];
    $script = $_SERVER['SCRIPT_NAME'];
    $path = dirname(dirname($script)); // Go up one level from public/
    return $protocol . '://' . $host . $path;
}

function getImageUrl($imageName) {
    return getBaseUrl() . '/gambar/' . $imageName;
}

function isLoggedIn() {
    return isset($_SESSION['user_id']);
}

function getUserRole() {
    return $_SESSION['role'] ?? null;
}

// Database configuration
$config = [
    'host' => 'localhost',
    'username' => 'pnwy4699_dbuser',
    'password' => 'MyPass123456789!',
    'database' => 'pnwy4699_permohonan'
];

// Create database connection
try {
    $pdo = new PDO(
        "mysql:host={$config['host']};dbname={$config['database']};charset=utf8mb4",
        $config['username'],
        $config['password'],
        [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
            PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC,
            PDO::ATTR_EMULATE_PREPARES => false
        ]
    );
} catch (PDOException $e) {
    die("Database connection failed: " . $e->getMessage());
}

function hasRole($role) {
    return getUserRole() === $role;
}

function setFlashMessage($type, $message) {
    $_SESSION['flash_' . $type] = $message;
}

function getFlashMessage($type) {
    if (isset($_SESSION['flash_' . $type])) {
        $message = $_SESSION['flash_' . $type];
        unset($_SESSION['flash_' . $type]);
        return $message;
    }
    return null;
}

// Check if setup is needed
$page = $_GET['page'] ?? 'home';

// Simple routing
switch ($page) {
    case 'login':
        include 'login.php';
        break;
    case 'register':
        include 'register.php';
        break;
    case 'logout':
        include 'logout.php';
        break;
    case 'dashboard':
        include 'dashboard.php';
        break;
    case 'verifikasi':
        include 'verifikasi.php';
        break;
    case 'permohonan-baru':
        include 'permohonan-baru.php';
        break;
    case 'permohonan-saya':
        include 'permohonan-saya.php';
        break;
    case 'detail-permohonan':
        include 'detail-permohonan.php';
        break;
    case 'print-permohonan':
        include 'print-permohonan.php';
        break;
    case 'galeri':
        include 'galeri.php';
        break;
    case 'kelola-user':
        include 'kelola-user.php';
        break;
    case 'user-ajax':
        include 'user-ajax.php';
        break;
    case 'check-users':
        include 'check-users.php';
        break;
    default:
        include 'home.php';
        break;
}
?>
