// Force reload images to fix cache issues
document.addEventListener('DOMContentLoaded', function() {
    // Add timestamp to all images to prevent caching
    const images = document.querySelectorAll('img[src*="gambar/"]');
    const timestamp = Date.now();
    
    images.forEach(function(img) {
        const src = img.src;
        const separator = src.includes('?') ? '&' : '?';
        img.src = src + separator + 'v=' + timestamp;
        
        // Add load/error handlers for debugging
        img.onload = function() {
            console.log('Image loaded successfully:', this.src);
        };
        
        img.onerror = function() {
            console.error('Image failed to load:', this.src);
            // Fallback: try without timestamp
            this.src = this.src.split('?')[0];
        };
    });
    
    // Also handle background images in CSS
    const elements = document.querySelectorAll('[style*="background-image"]');
    elements.forEach(function(el) {
        const style = el.style.backgroundImage;
        if (style && style.includes('gambar/')) {
            const urlMatch = style.match(/url\(['"]?([^'"]+)['"]?\)/);
            if (urlMatch) {
                const url = urlMatch[1];
                const separator = url.includes('?') ? '&' : '?';
                const newUrl = url + separator + 'v=' + timestamp;
                el.style.backgroundImage = style.replace(url, newUrl);
                console.log('Background image updated:', newUrl);
            }
        }
    });
});
