<?php
// Check if user is logged in
if (!isLoggedIn()) {
    redirect('?page=login');
}

// Get permohonan ID from URL
$permohonanId = $_GET['id'] ?? '';

if (empty($permohonanId)) {
    setFlashMessage('error', 'ID Permohonan tidak valid');
    redirect('?page=dashboard');
}

// Get permohonan data
$stmt = $pdo->prepare("
    SELECT p.*, u.username, u.email, 
           prof.nama_lengkap, prof.nik, prof.no_telepon, prof.alamat
    FROM permohonans p
    JOIN users u ON p.pemohon_id = u.id
    LEFT JOIN pemohon_profiles prof ON u.id = prof.user_id
    WHERE p.id = ?
");
$stmt->execute([$permohonanId]);
$permohonan = $stmt->fetch();

if (!$permohonan) {
    setFlashMessage('error', 'Permohonan tidak ditemukan');
    redirect('?page=dashboard');
}

// Check access rights
if (getUserRole() === 'pemohon' && $permohonan['pemohon_id'] != $_SESSION['user_id']) {
    setFlashMessage('error', 'Anda tidak memiliki akses ke permohonan ini');
    redirect('?page=dashboard');
}

// Get files
$stmt = $pdo->prepare("SELECT * FROM permohonan_files WHERE permohonan_id = ?");
$stmt->execute([$permohonanId]);
$files = $stmt->fetchAll();

$statusLabels = [
    'pending' => ['label' => 'Menunggu', 'color' => 'warning'],
    'processing' => ['label' => 'Diproses', 'color' => 'info'],
    'completed' => ['label' => 'Selesai', 'color' => 'success'],
    'rejected' => ['label' => 'Ditolak', 'color' => 'danger']
];
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Detail Permohonan - <?= htmlspecialchars($permohonan['kode_permohonan']) ?></title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        .bg-primary-custom {
            background: linear-gradient(135deg, #1e3a8a, #3b82f6);
        }
        .official-header {
            background: white;
            border: 2px solid #000;
            padding: 20px;
            margin-bottom: 30px;
            background-image: url('/permohonan-salinan-putusan/gambar/kop_surat.png');
            background-size: contain;
            background-repeat: no-repeat;
            background-position: center top;
            min-height: 150px;
            display: flex;
            align-items: end;
        }
        .official-content {
            background: white;
            padding: 30px;
            border: 1px solid #ddd;
            border-radius: 5px;
            margin-bottom: 20px;
        }
        .print-only {
            display: none;
        }
        .no-print {
            display: block;
        }
        
        @media print {
            .no-print {
                display: none !important;
            }
            .print-only {
                display: block !important;
            }
            .official-header {
                background-size: 100% auto;
                min-height: 200px;
            }
            body {
                background: white !important;
            }
            .navbar, .btn, .alert {
                display: none !important;
            }
        }
        
        .status-badge {
            font-size: 0.875rem;
            padding: 0.375rem 0.75rem;
            border-radius: 0.5rem;
        }
        
        .signature-area {
            margin-top: 50px;
            text-align: right;
        }
        
        .signature-box {
            border: 1px solid #000;
            height: 100px;
            width: 200px;
            margin: 20px 0;
            display: inline-block;
        }
    </style>
</head>
<body class="bg-light">
    <!-- Navigation (No Print) -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary-custom no-print">
        <div class="container">
            <a class="navbar-brand d-flex align-items-center" href="setup.php">
                <img src="/permohonan-salinan-putusan/gambar/Logo_pnwtp.png" alt="PN Watampone" height="35" class="me-2">
                <span>PN Watampone</span>
            </a>
            <div class="navbar-nav ms-auto">
                <a class="nav-link" href="?page=dashboard">
                    <i class="fas fa-arrow-left me-1"></i> Kembali
                </a>
                <a class="nav-link" href="javascript:window.print()">
                    <i class="fas fa-print me-1"></i> Print
                </a>
            </div>
        </div>
    </nav>

    <!-- Main Content -->
    <main class="py-4">
        <div class="container">
            <!-- Print Actions (No Print) -->
            <div class="row mb-4 no-print">
                <div class="col-12">
                    <div class="d-flex justify-content-between align-items-center">
                        <h1 class="h3 mb-0">
                            <i class="fas fa-file-alt me-2"></i>
                            Detail Permohonan
                        </h1>
                        <div>
                            <button onclick="window.print()" class="btn btn-primary me-2">
                                <i class="fas fa-print me-1"></i> Print Dokumen
                            </button>
                            <a href="?page=dashboard" class="btn btn-secondary">
                                <i class="fas fa-arrow-left me-1"></i> Kembali
                            </a>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Official Document -->
            <div class="official-header">
                <div class="w-100 text-center">
                    <h4 class="mb-0 fw-bold">SURAT PERMOHONAN FOTOKOPI SALINAN PUTUSAN</h4>
                    <p class="mb-0">Nomor: <?= htmlspecialchars($permohonan['kode_permohonan']) ?></p>
                </div>
            </div>

            <div class="official-content">
                <!-- Permohonan Details -->
                <div class="row mb-4">
                    <div class="col-md-6">
                        <h6 class="fw-bold">Data Pemohon:</h6>
                        <table class="table table-borderless table-sm">
                            <tr>
                                <td width="30%">Nama</td>
                                <td>: <?= htmlspecialchars($permohonan['nama_lengkap'] ?? $permohonan['username']) ?></td>
                            </tr>
                            <tr>
                                <td>NIK</td>
                                <td>: <?= htmlspecialchars($permohonan['nik'] ?? '-') ?></td>
                            </tr>
                            <tr>
                                <td>No. Telepon</td>
                                <td>: <?= htmlspecialchars($permohonan['no_telepon'] ?? '-') ?></td>
                            </tr>
                            <tr>
                                <td>Email</td>
                                <td>: <?= htmlspecialchars($permohonan['email']) ?></td>
                            </tr>
                            <tr>
                                <td>Alamat</td>
                                <td>: <?= htmlspecialchars($permohonan['alamat'] ?? '-') ?></td>
                            </tr>
                        </table>
                    </div>
                    <div class="col-md-6">
                        <h6 class="fw-bold">Data Permohonan:</h6>
                        <table class="table table-borderless table-sm">
                            <tr>
                                <td width="30%">Kode</td>
                                <td>: <?= htmlspecialchars($permohonan['kode_permohonan']) ?></td>
                            </tr>
                            <tr>
                                <td>Tanggal</td>
                                <td>: <?= date('d F Y', strtotime($permohonan['created_at'])) ?></td>
                            </tr>
                            <tr>
                                <td>Status</td>
                                <td>: 
                                    <span class="badge bg-<?= $statusLabels[$permohonan['status']]['color'] ?> status-badge">
                                        <?= $statusLabels[$permohonan['status']]['label'] ?>
                                    </span>
                                </td>
                            </tr>
                        </table>
                    </div>
                </div>

                <!-- Case Details -->
                <div class="mb-4">
                    <h6 class="fw-bold">Data Perkara:</h6>
                    <table class="table table-bordered">
                        <tr>
                            <td width="25%" class="fw-bold">Nomor Perkara</td>
                            <td><?= htmlspecialchars($permohonan['nomor_perkara']) ?></td>
                        </tr>
                        <tr>
                            <td class="fw-bold">Tahun</td>
                            <td><?= htmlspecialchars($permohonan['tahun_perkara']) ?></td>
                        </tr>
                        <tr>
                            <td class="fw-bold">Para Pihak</td>
                            <td><?= htmlspecialchars($permohonan['para_pihak']) ?></td>
                        </tr>
                        <tr>
                            <td class="fw-bold">Jenis Perkara</td>
                            <td><?= htmlspecialchars($permohonan['jenis_perkara']) ?></td>
                        </tr>
                        <tr>
                            <td class="fw-bold">Kebutuhan</td>
                            <td><?= htmlspecialchars($permohonan['kebutuhan']) ?></td>
                        </tr>
                        <?php if ($permohonan['keterangan']): ?>
                        <tr>
                            <td class="fw-bold">Keterangan</td>
                            <td><?= htmlspecialchars($permohonan['keterangan']) ?></td>
                        </tr>
                        <?php endif; ?>
                    </table>
                </div>

                <!-- Files List -->
                <?php if (!empty($files)): ?>
                <div class="mb-4">
                    <h6 class="fw-bold">Dokumen Pendukung:</h6>
                    <ul class="list-group">
                        <?php foreach ($files as $file): ?>
                        <li class="list-group-item d-flex justify-content-between align-items-center">
                            <div>
                                <i class="fas fa-file me-2"></i>
                                <?= htmlspecialchars($file['file_name']) ?>
                                <small class="text-muted">(<?= number_format($file['file_size']/1024, 2) ?> KB)</small>
                            </div>
                            <span class="badge bg-primary rounded-pill"><?= htmlspecialchars($file['file_type']) ?></span>
                        </li>
                        <?php endforeach; ?>
                    </ul>
                </div>
                <?php endif; ?>

                <!-- Status Information -->
                <?php if ($permohonan['status'] === 'rejected' && $permohonan['rejection_reason']): ?>
                <div class="alert alert-danger">
                    <h6><i class="fas fa-exclamation-triangle me-2"></i>Alasan Penolakan:</h6>
                    <p class="mb-0"><?= htmlspecialchars($permohonan['rejection_reason']) ?></p>
                </div>
                <?php endif; ?>

                <!-- Signature Area -->
                <div class="signature-area">
                    <p>Watampone, <?= date('d F Y') ?></p>
                    <p class="mb-1">Pemohon,</p>
                    <div class="signature-box"></div>
                    <p class="fw-bold"><?= htmlspecialchars($permohonan['nama_lengkap'] ?? $permohonan['username']) ?></p>
                </div>

                <!-- Footer Print Only -->
                <div class="print-only mt-5 pt-3" style="border-top: 1px solid #ccc;">
                    <small class="text-muted">
                        Dokumen ini dicetak secara otomatis dari Sistem Permohonan Salinan Putusan<br>
                        Pengadilan Negeri Watampone - <?= date('d F Y H:i:s') ?>
                    </small>
                </div>
            </div>
        </div>
    </main>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
