<?php
// Check if user is logged in
if (!isLoggedIn()) {
    redirect('?page=login');
}

$userRole = getUserRole();
$userId = $_SESSION['user_id'];

// Get user data
$stmt = $pdo->prepare("
    SELECT u.*, p.nama_lengkap, p.nik, p.no_telepon, p.alamat, p.status_verified 
    FROM users u 
    LEFT JOIN pemohon_profiles p ON p.user_id = u.id 
    WHERE u.id = ?
");
$stmt->execute([$userId]);
$userData = $stmt->fetch();

// Get statistics based on role
$stats = [];

if ($userRole === 'admin' || $userRole === 'petugas') {
    // User statistics
    $stmt = $pdo->query("SELECT 
        COUNT(*) as total,
        SUM(CASE WHEN role = 'admin' THEN 1 ELSE 0 END) as admin,
        SUM(CASE WHEN role = 'petugas' THEN 1 ELSE 0 END) as petugas,
        SUM(CASE WHEN role = 'pemohon' THEN 1 ELSE 0 END) as pemohon,
        SUM(CASE WHEN is_active = 1 THEN 1 ELSE 0 END) as active
        FROM users
    ");
    $stats['users'] = $stmt->fetch();
    
    // Pemohon statistics
    $stmt = $pdo->query("SELECT 
        COUNT(*) as total,
        SUM(CASE WHEN status_verified = 'pending' THEN 1 ELSE 0 END) as pending,
        SUM(CASE WHEN status_verified = 'verified' THEN 1 ELSE 0 END) as verified,
        SUM(CASE WHEN status_verified = 'rejected' THEN 1 ELSE 0 END) as rejected
        FROM pemohon_profiles
    ");
    $stats['pemohon'] = $stmt->fetch();
}

if ($userRole === 'pemohon') {
    // Get user's permohonan (will be implemented later)
    $stats['my_permohonan'] = ['total' => 0, 'pending' => 0, 'selesai' => 0];
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Dashboard - Permohonan Salinan Putusan</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        .navbar-brand img {
            height: 40px;
        }
        .bg-primary-custom {
            background: linear-gradient(135deg, #1e3a8a, #3b82f6);
        }
        .card-custom {
            border: none;
            border-radius: 15px;
            box-shadow: 0 10px 30px rgba(0,0,0,0.1);
        }
        .stats-card {
            border-left: 4px solid;
            transition: transform 0.3s ease;
        }
        .stats-card:hover {
            transform: translateY(-5px);
        }
        .border-left-primary { border-left-color: #007bff !important; }
        .border-left-success { border-left-color: #28a745 !important; }
        .border-left-info { border-left-color: #17a2b8 !important; }
        .border-left-warning { border-left-color: #ffc107 !important; }
        .border-left-danger { border-left-color: #dc3545 !important; }
    </style>
</head>
<body class="bg-light">
    <!-- Navigation -->
    <nav class="navbar navbar-expand-lg navbar-dark bg-primary-custom">
        <div class="container">
            <a class="navbar-brand d-flex align-items-center" href="setup.php">
                <img src="/permohonan-salinan-putusan/gambar/Logo_pnwtp.png" alt="PN Watampone" height="35" class="me-2">
                <span>PN Watampone</span>
            </a>
            <button class="navbar-toggler" type="button" data-bs-toggle="collapse" data-bs-target="#navbarNav">
                <span class="navbar-toggler-icon"></span>
            </button>
            <div class="collapse navbar-collapse" id="navbarNav">
                <ul class="navbar-nav me-auto">
                    <li class="nav-item">
                        <a class="nav-link active" href="?page=dashboard">
                            <i class="fas fa-tachometer-alt me-1"></i> Dashboard
                        </a>
                    </li>
                    <?php if (in_array(getUserRole(), ['petugas', 'admin'])): ?>
                    <li class="nav-item">
                        <a class="nav-link" href="?page=verifikasi">
                            <i class="fas fa-user-check me-1"></i> Verifikasi Akun
                        </a>
                    </li>
                    <?php endif; ?>
                    
                    <?php if (in_array(getUserRole(), ['petugas', 'admin'])): ?>
                    <li class="nav-item">
                        <a class="nav-link" href="?page=kelola-user">
                            <i class="fas fa-users me-1"></i> Daftar Pemohon
                        </a>
                    </li>
                    <?php endif; ?>
                    <?php if (getUserRole() === 'admin'): ?>
                    <li class="nav-item">
                        <a class="nav-link" href="?page=galeri">
                            <i class="fas fa-images me-1"></i> Galeri Gambar
                        </a>
                    </li>
                    <?php endif; ?>
                    <?php if (getUserRole() === 'pemohon'): ?>
                    <li class="nav-item">
                        <a class="nav-link" href="?page=permohonan-baru">
                            <i class="fas fa-plus-circle me-1"></i> Permohonan Baru
                        </a>
                    </li>
                    <li class="nav-item">
                        <a class="nav-link" href="?page=permohonan-saya">
                            <i class="fas fa-list me-1"></i> Permohonan Saya
                        </a>
                    </li>
                    <?php endif; ?>
                    
                    <?php if ($userRole === 'admin'): ?>
                        <li class="nav-item">
                            <a class="nav-link" href="?page=galeri">
                                <i class="fas fa-images me-1"></i> Galeri Gambar
                            </a>
                        </li>
                    <?php endif; ?>
                    
                    <?php if ($userRole === 'pemohon'): ?>
                        <li class="nav-item">
                            <a class="nav-link" href="#" onclick="alert('Feature coming soon!')">
                                <i class="fas fa-file-plus me-1"></i> Ajukan Permohonan
                            </a>
                        </li>
                    <?php endif; ?>
                </ul>
                
                <ul class="navbar-nav">
                    <li class="nav-item dropdown">
                        <a class="nav-link dropdown-toggle" href="#" id="navbarDropdown" role="button" data-bs-toggle="dropdown">
                            <i class="fas fa-user me-1"></i>
                            <?= htmlspecialchars($_SESSION['nama_lengkap']) ?>
                            <span class="badge bg-light text-dark ms-1"><?= ucfirst($userRole) ?></span>
                        </a>
                        <ul class="dropdown-menu">
                            <li><a class="dropdown-item" href="#" onclick="alert('Feature coming soon!')">
                                <i class="fas fa-user-edit me-2"></i> Profil
                            </a></li>
                            <li><hr class="dropdown-divider"></li>
                            <li><a class="dropdown-item" href="?page=logout">
                                <i class="fas fa-sign-out-alt me-2"></i> Logout
                            </a></li>
                        </ul>
                    </li>
                </ul>
            </div>
        </div>
    </nav>

    <!-- Main Content -->
    <main class="py-4">
        <div class="container-fluid">
            <!-- Header -->
            <div class="d-sm-flex align-items-center justify-content-between mb-4">
                <h1 class="h3 mb-0 text-gray-800">
                    <i class="fas fa-tachometer-alt me-2"></i>
                    Dashboard <?= ucfirst($userRole) ?>
                </h1>
                <div class="d-sm-flex">
                    <span class="badge bg-primary px-3 py-2">
                        <i class="fas fa-calendar me-1"></i>
                        <?= date('d F Y, H:i') ?> WIB
                    </span>
                </div>
            </div>

            <!-- Flash Messages -->
            <?php if ($success = getFlashMessage('success')): ?>
                <div class="alert alert-success alert-dismissible fade show" role="alert">
                    <i class="fas fa-check-circle me-2"></i>
                    <?= htmlspecialchars($success) ?>
                    <button type="button" class="btn-close" data-bs-dismiss="alert"></button>
                </div>
            <?php endif; ?>

            <!-- Statistics Cards -->
            <div class="row">
                <?php if ($userRole === 'admin' || $userRole === 'petugas'): ?>
                    <!-- Users Statistics -->
                    <div class="col-xl-3 col-md-6 mb-4">
                        <div class="card stats-card border-left-primary h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                            Total Users
                                        </div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">
                                            <?= $stats['users']['total'] ?>
                                        </div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="fas fa-users fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                                <small class="text-muted">
                                    Admin: <?= $stats['users']['admin'] ?> | 
                                    Petugas: <?= $stats['users']['petugas'] ?> | 
                                    Pemohon: <?= $stats['users']['pemohon'] ?>
                                </small>
                            </div>
                        </div>
                    </div>

                    <!-- Pemohon Verified -->
                    <div class="col-xl-3 col-md-6 mb-4">
                        <div class="card stats-card border-left-success h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                            Pemohon Verified
                                        </div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">
                                            <?= $stats['pemohon']['verified'] ?>
                                        </div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="fas fa-user-check fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                                <small class="text-muted">
                                    Pending: <?= $stats['pemohon']['pending'] ?> | 
                                    Rejected: <?= $stats['pemohon']['rejected'] ?>
                                </small>
                            </div>
                        </div>
                    </div>

                    <!-- System Info -->
                    <div class="col-xl-3 col-md-6 mb-4">
                        <div class="card stats-card border-left-info h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                            PHP Version
                                        </div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">
                                            <?= PHP_VERSION ?>
                                        </div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="fas fa-server fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                                <small class="text-muted">
                                    Compatible & Running
                                </small>
                            </div>
                        </div>
                    </div>

                    <!-- Database Info -->
                    <div class="col-xl-3 col-md-6 mb-4">
                        <div class="card stats-card border-left-warning h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                            Database
                                        </div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">
                                            MySQL
                                        </div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="fas fa-database fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                                <small class="text-muted">
                                    Connected & Active
                                </small>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>

                <?php if ($userRole === 'pemohon'): ?>
                    <!-- My Permohonan -->
                    <div class="col-xl-4 col-md-6 mb-4">
                        <div class="card stats-card border-left-primary h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                            Permohonan Saya
                                        </div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">
                                            <?= $stats['my_permohonan']['total'] ?>
                                        </div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="fas fa-file-alt fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                                <small class="text-muted">
                                    Total permohonan yang diajukan
                                </small>
                            </div>
                        </div>
                    </div>

                    <!-- Account Status -->
                    <div class="col-xl-4 col-md-6 mb-4">
                        <div class="card stats-card border-left-success h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                            Status Akun
                                        </div>
                                        <div class="h5 mb-0 font-weight-bold text-gray-800">
                                            <?= ucfirst($userData['status_verified'] ?? 'N/A') ?>
                                        </div>
                                    </div>
                                    <div class="col-auto">
                                        <i class="fas fa-user-check fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                                <small class="text-muted">
                                    Akun sudah diverifikasi
                                </small>
                            </div>
                        </div>
                    </div>

                    <!-- Quick Action -->
                    <div class="col-xl-4 col-md-6 mb-4">
                        <div class="card stats-card border-left-info h-100 py-2">
                            <div class="card-body">
                                <div class="row no-gutters align-items-center">
                                    <div class="col mr-2">
                                        <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                            Quick Action
                                        </div>
                                        <button class="btn btn-info btn-sm" onclick="alert('Feature coming soon!')">
                                            <i class="fas fa-plus me-1"></i>
                                            Ajukan Permohonan
                                        </button>
                                    </div>
                                    <div class="col-auto">
                                        <i class="fas fa-bolt fa-2x text-gray-300"></i>
                                    </div>
                                </div>
                                <small class="text-muted">
                                    Buat permohonan baru
                                </small>
                            </div>
                        </div>
                    </div>
                <?php endif; ?>
            </div>

            <!-- Content Sections -->
            <div class="row">
                <!-- User Info -->
                <div class="col-xl-8 col-lg-7">
                    <div class="card card-custom mb-4">
                        <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                            <h6 class="m-0 font-weight-bold text-primary">
                                <i class="fas fa-user me-2"></i>Informasi Akun
                            </h6>
                        </div>
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-6">
                                    <table class="table table-borderless">
                                        <tr>
                                            <td><strong>Username:</strong></td>
                                            <td><?= htmlspecialchars($userData['username']) ?></td>
                                        </tr>
                                        <tr>
                                            <td><strong>Email:</strong></td>
                                            <td><?= htmlspecialchars($userData['email']) ?></td>
                                        </tr>
                                        <tr>
                                            <td><strong>Role:</strong></td>
                                            <td>
                                                <span class="badge bg-primary">
                                                    <?= ucfirst($userData['role']) ?>
                                                </span>
                                            </td>
                                        </tr>
                                        <?php if ($userData['nama_lengkap']): ?>
                                        <tr>
                                            <td><strong>Nama Lengkap:</strong></td>
                                            <td><?= htmlspecialchars($userData['nama_lengkap']) ?></td>
                                        </tr>
                                        <?php endif; ?>
                                    </table>
                                </div>
                                <div class="col-md-6">
                                    <?php if ($userData['nik']): ?>
                                    <table class="table table-borderless">
                                        <tr>
                                            <td><strong>NIK:</strong></td>
                                            <td><?= htmlspecialchars($userData['nik']) ?></td>
                                        </tr>
                                        <tr>
                                            <td><strong>No. Telepon:</strong></td>
                                            <td><?= htmlspecialchars($userData['no_telepon']) ?></td>
                                        </tr>
                                        <tr>
                                            <td><strong>Status:</strong></td>
                                            <td>
                                                <?php
                                                $statusClass = [
                                                    'pending' => 'bg-warning',
                                                    'verified' => 'bg-success',
                                                    'rejected' => 'bg-danger'
                                                ];
                                                $status = $userData['status_verified'] ?? 'pending';
                                                ?>
                                                <span class="badge <?= $statusClass[$status] ?? 'bg-secondary' ?>">
                                                    <?= ucfirst($status) ?>
                                                </span>
                                            </td>
                                        </tr>
                                        <tr>
                                            <td><strong>Terdaftar:</strong></td>
                                            <td><?= date('d/m/Y H:i', strtotime($userData['created_at'])) ?></td>
                                        </tr>
                                    </table>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Quick Actions -->
                <div class="col-xl-4 col-lg-5">
                    <div class="card card-custom mb-4">
                        <div class="card-header py-3">
                            <h6 class="m-0 font-weight-bold text-primary">
                                <i class="fas fa-bolt me-2"></i>Quick Actions
                            </h6>
                        </div>
                        <div class="card-body">
                            <div class="list-group list-group-flush">
                                <?php if ($userRole === 'admin'): ?>
                                    <a href="#" onclick="alert('Feature coming soon!')" class="list-group-item list-group-item-action d-flex align-items-center">
                                        <i class="fas fa-user-plus text-primary me-3"></i>
                                        <div>
                                            <h6 class="mb-1">Tambah User Baru</h6>
                                            <small class="text-muted">Buat akun admin atau petugas</small>
                                        </div>
                                    </a>
                                <?php endif; ?>
                                
                                <?php if ($userRole === 'petugas'): ?>
                                    <a href="#" onclick="alert('Feature coming soon!')" class="list-group-item list-group-item-action d-flex align-items-center">
                                        <i class="fas fa-user-check text-success me-3"></i>
                                        <div>
                                            <h6 class="mb-1">Verifikasi Akun</h6>
                                            <small class="text-muted">Proses verifikasi pemohon</small>
                                        </div>
                                    </a>
                                <?php endif; ?>
                                
                                <?php if ($userRole === 'pemohon'): ?>
                                    <a href="#" onclick="alert('Feature coming soon!')" class="list-group-item list-group-item-action d-flex align-items-center">
                                        <i class="fas fa-file-plus text-info me-3"></i>
                                        <div>
                                            <h6 class="mb-1">Ajukan Permohonan</h6>
                                            <small class="text-muted">Buat permohonan salinan putusan</small>
                                        </div>
                                    </a>
                                <?php endif; ?>
                                
                                <a href="#" onclick="alert('Feature coming soon!')" class="list-group-item list-group-item-action d-flex align-items-center">
                                    <i class="fas fa-user-edit text-warning me-3"></i>
                                    <div>
                                        <h6 class="mb-1">Edit Profil</h6>
                                        <small class="text-muted">Update informasi akun</small>
                                    </div>
                                </a>
                            </div>
                        </div>
                    </div>

                    <!-- System Status -->
                    <div class="card card-custom">
                        <div class="card-header py-3">
                            <h6 class="m-0 font-weight-bold text-primary">
                                <i class="fas fa-info-circle me-2"></i>System Status
                            </h6>
                        </div>
                        <div class="card-body">
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <span>Database</span>
                                <span class="badge bg-success">Connected</span>
                            </div>
                            <div class="d-flex justify-content-between align-items-center mb-2">
                                <span>PHP Version</span>
                                <span class="badge bg-info"><?= PHP_VERSION ?></span>
                            </div>
                            <div class="d-flex justify-content-between align-items-center">
                                <span>Application</span>
                                <span class="badge bg-success">Running</span>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </main>

    <!-- Footer -->
    <footer class="bg-primary-custom text-white py-4">
        <div class="container">
            <div class="row">
                <div class="col-md-6">
                    <h6><i class="fas fa-gavel me-2"></i>Pengadilan Negeri Watampone</h6>
                    <p class="mb-0">Sistem Permohonan Salinan Putusan Online</p>
                </div>
                <div class="col-md-6 text-md-end">
                    <p class="mb-0">&copy; <?= date('Y') ?> PN Watampone. All rights reserved.</p>
                    <small>Compatible with PHP <?= PHP_VERSION ?></small>
                </div>
            </div>
        </div>
    </footer>

    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
    <script>
        // Auto-hide alerts after 5 seconds
        setTimeout(function() {
            $('.alert').fadeOut('slow');
        }, 5000);
    </script>
</body>
</html>
