<?php
// Cek data user yang ada di database
require_once '../config.php';

echo "<h3>Daftar User dalam Database:</h3>";

try {
    $stmt = $pdo->query("SELECT id, nama_lengkap, username, email, role, is_active FROM users ORDER BY id");
    $users = $stmt->fetchAll();
    
    if ($users) {
        echo "<table border='1' style='border-collapse: collapse; width: 100%;'>";
        echo "<tr><th>ID</th><th>Nama</th><th>Username</th><th>Email</th><th>Role</th><th>Status</th></tr>";
        
        foreach ($users as $user) {
            echo "<tr>";
            echo "<td>" . $user['id'] . "</td>";
            echo "<td>" . htmlspecialchars($user['nama_lengkap']) . "</td>";
            echo "<td>" . htmlspecialchars($user['username']) . "</td>";
            echo "<td>" . htmlspecialchars($user['email']) . "</td>";
            echo "<td><strong>" . ucfirst($user['role']) . "</strong></td>";
            echo "<td>" . ($user['is_active'] ? 'Aktif' : 'Nonaktif') . "</td>";
            echo "</tr>";
        }
        echo "</table>";
    } else {
        echo "<p>Tidak ada user dalam database.</p>";
    }
    
    echo "<br><h3>Password untuk semua akun demo: <code>password</code></h3>";
    
} catch (Exception $e) {
    echo "Error: " . $e->getMessage();
}
?>
