<?php
// Include configuration
require_once '../config.php';

// Start session if not started
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Get database connection
$pdo = getDbConnection();

// Helper functions
function setFlashMessage($type, $message) {
    $_SESSION['flash'][$type] = $message;
}

function getFlashMessage($type) {
    if (isset($_SESSION['flash'][$type])) {
        $message = $_SESSION['flash'][$type];
        unset($_SESSION['flash'][$type]);
        return $message;
    }
    return null;
}

$login_success = false;
$user_info = null;

// Handle login form submission
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $login_field = $_POST['login_field'] ?? '';
    $password = $_POST['password'] ?? '';
    
    if (empty($login_field) || empty($password)) {
        setFlashMessage('error', 'Username/Email/No. Telepon dan password harus diisi');
    } else {
        // Check user in database - support username, email, or phone number
        $stmt = $pdo->prepare("
            SELECT * FROM users 
            WHERE (username = ? OR email = ? OR nomor_hp = ?)
            LIMIT 1
        ");
        $stmt->execute([$login_field, $login_field, $login_field]);
        $user = $stmt->fetch();
        
        if ($user && password_verify($password, $user['password'])) {
            // Set session
            $_SESSION['user_id'] = $user['id'];
            $_SESSION['username'] = $user['username'];
            $_SESSION['email'] = $user['email'];
            $_SESSION['role'] = $user['role'];
            $_SESSION['nama_lengkap'] = $user['nama_lengkap'];
            
            $login_success = true;
            $user_info = $user;
            setFlashMessage('success', 'Login berhasil!');
        } else {
            setFlashMessage('error', 'Username/Email/No. Telepon atau password salah');
        }
    }
}

// Handle logout
if (isset($_GET['logout'])) {
    session_destroy();
    session_start();
    setFlashMessage('success', 'Logout berhasil!');
}
?>

<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login Test - Permohonan Salinan Putusan</title>
    <link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.4.0/css/all.min.css" rel="stylesheet">
    <style>
        .login-container {
            min-height: 100vh;
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
        }
        .login-card {
            background: rgba(255, 255, 255, 0.95);
            border-radius: 15px;
            box-shadow: 0 15px 35px rgba(0, 0, 0, 0.1);
        }
        .login-header {
            background: linear-gradient(135deg, #667eea 0%, #764ba2 100%);
            color: white;
            border-radius: 15px 15px 0 0;
        }
    </style>
</head>
<body>
    <div class="login-container d-flex align-items-center justify-content-center">
        <div class="container">
            <div class="row justify-content-center">
                <div class="col-md-8 col-lg-6">
                    
                    <?php if ($login_success && $user_info): ?>
                        <!-- Success Login Display -->
                        <div class="login-card">
                            <div class="login-header text-center p-4">
                                <img src="Logo_pnwtp.png" alt="Logo PN Watampone" style="height: 60px;" class="mb-3">
                                <h4>✅ Login Berhasil!</h4>
                                <p class="mb-0">Selamat datang di Sistem</p>
                            </div>
                            
                            <div class="card-body p-4">
                                <div class="alert alert-success">
                                    <i class="fas fa-check-circle"></i> <strong>LOGIN BERHASIL!</strong><br>
                                    Selamat datang, <?= htmlspecialchars($user_info['nama_lengkap']) ?>
                                </div>
                                
                                <div class="row">
                                    <div class="col-md-6">
                                        <h6>📋 Informasi Akun:</h6>
                                        <table class="table table-sm">
                                            <tr>
                                                <td><strong>Nama:</strong></td>
                                                <td><?= htmlspecialchars($user_info['nama_lengkap']) ?></td>
                                            </tr>
                                            <tr>
                                                <td><strong>Username:</strong></td>
                                                <td><?= htmlspecialchars($user_info['username']) ?></td>
                                            </tr>
                                            <tr>
                                                <td><strong>Email:</strong></td>
                                                <td><?= htmlspecialchars($user_info['email']) ?></td>
                                            </tr>
                                            <tr>
                                                <td><strong>Role:</strong></td>
                                                <td>
                                                    <span class="badge bg-<?= $user_info['role'] === 'admin' ? 'danger' : 'primary' ?>">
                                                        <?= ucfirst($user_info['role']) ?>
                                                    </span>
                                                </td>
                                            </tr>
                                        </table>
                                    </div>
                                    
                                    <div class="col-md-6">
                                        <h6>🔧 Status Sistem:</h6>
                                        <ul class="list-group list-group-flush">
                                            <li class="list-group-item">✅ Database: Terhubung</li>
                                            <li class="list-group-item">✅ Authentication: Berhasil</li>
                                            <li class="list-group-item">✅ Session: Aktif</li>
                                            <li class="list-group-item">✅ Hosting: Online</li>
                                        </ul>
                                    </div>
                                </div>
                                
                                <hr>
                                
                                <div class="alert alert-info">
                                    <h6><i class="fas fa-info-circle"></i> Aplikasi Siap Digunakan!</h6>
                                    <p class="mb-0">Database sudah terkonfigurasi dengan benar dan sistem login berfungsi normal.</p>
                                </div>
                                
                                <div class="text-center">
                                    <a href="dashboard_test.php" class="btn btn-success me-2">
                                        <i class="fas fa-tachometer-alt"></i> Dashboard Test
                                    </a>
                                    <a href="?logout=1" class="btn btn-outline-danger">
                                        <i class="fas fa-sign-out-alt"></i> Logout
                                    </a>
                                </div>
                            </div>
                        </div>
                        
                    <?php else: ?>
                        <!-- Login Form -->
                        <div class="login-card">
                            <div class="login-header text-center p-4">
                                <img src="Logo_pnwtp.png" alt="Logo PN Watampone" style="height: 60px;" class="mb-3">
                                <h4>🔐 Login Test</h4>
                                <p class="mb-0">Permohonan Salinan Putusan</p>
                            </div>
                            
                            <div class="card-body p-4">
                                <?php if ($error = getFlashMessage('error')): ?>
                                    <div class="alert alert-danger">
                                        <i class="fas fa-exclamation-circle"></i> <?= htmlspecialchars($error) ?>
                                    </div>
                                <?php endif; ?>
                                
                                <?php if ($success = getFlashMessage('success')): ?>
                                    <div class="alert alert-success">
                                        <i class="fas fa-check-circle"></i> <?= htmlspecialchars($success) ?>
                                    </div>
                                <?php endif; ?>
                                
                                <form method="POST" action="">
                                    <div class="mb-3">
                                        <label for="login_field" class="form-label">
                                            <i class="fas fa-user"></i> Username / Email / No. HP
                                        </label>
                                        <input type="text" 
                                               class="form-control" 
                                               id="login_field" 
                                               name="login_field" 
                                               placeholder="Masukkan username, email, atau nomor HP"
                                               required>
                                    </div>
                                    
                                    <div class="mb-4">
                                        <label for="password" class="form-label">
                                            <i class="fas fa-lock"></i> Password
                                        </label>
                                        <input type="password" 
                                               class="form-control" 
                                               id="password" 
                                               name="password" 
                                               placeholder="Masukkan password"
                                               required>
                                    </div>
                                    
                                    <div class="d-grid mb-3">
                                        <button type="submit" class="btn btn-primary btn-lg">
                                            <i class="fas fa-sign-in-alt"></i> Login Test
                                        </button>
                                    </div>
                                </form>
                                
                                <hr>
                                
                                <div class="text-center">
                                    <h6>🎯 Akun Demo untuk Testing:</h6>
                                    <div class="row">
                                        <div class="col-md-4">
                                            <div class="card mb-2">
                                                <div class="card-body p-2">
                                                    <strong>👨‍💼 Admin</strong><br>
                                                    <code>admin</code><br>
                                                    <code>password</code>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="card mb-2">
                                                <div class="card-body p-2">
                                                    <strong>👨‍💻 Petugas</strong><br>
                                                    <code>petugas1</code><br>
                                                    <code>password</code>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4">
                                            <div class="card mb-2">
                                                <div class="card-body p-2">
                                                    <strong>👤 Pemohon</strong><br>
                                                    <code>pemohon_demo</code><br>
                                                    <code>password</code>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                            </div>
                        </div>
                    <?php endif; ?>
                    
                    <div class="text-center mt-3">
                        <a href="../" class="text-white">
                            <i class="fas fa-arrow-left"></i> Kembali ke Beranda
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>
    
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.0/dist/js/bootstrap.bundle.min.js"></script>
</body>
</html>
