<?php
// Configuration file for XAMPP
// Basic configuration for the application

// Database configuration - sekarang menggunakan .env file di CodeIgniter 4
// File ini hanya untuk compatibility dengan file-file lama

// Error reporting
error_reporting(E_ALL);
ini_set('display_errors', 1);

// Session configuration
if (session_status() == PHP_SESSION_NONE) {
    session_start();
}

// Base configuration
define('BASE_URL', 'https://pnwtp.site/permohonan-salinan-putusan/');
define('SITE_NAME', 'Sistem Permohonan Salinan Putusan');

// Database configuration for legacy files
$db_config = [
    'host' => 'localhost',
    'username' => 'pnwy4699_dbuser',
    'password' => 'MyPass123456789!',
    'database' => 'pnwy4699_permohonan'
];

// Helper functions
if (!function_exists('isLoggedIn')) {
    function isLoggedIn() {
        return isset($_SESSION['user_id']);
    }
}

if (!function_exists('getUserRole')) {
    function getUserRole() {
        return $_SESSION['role'] ?? null;
    }
}

if (!function_exists('getUserId')) {
    function getUserId() {
        return $_SESSION['user_id'] ?? null;
    }
}

if (!function_exists('redirect')) {
    function redirect($url) {
        header("Location: $url");
        exit();
    }
}

// Create database connection for legacy files
if (!function_exists('getDbConnection')) {
    function getDbConnection() {
        global $db_config;
        try {
        $pdo = new PDO(
            "mysql:host={$db_config['host']};dbname={$db_config['database']};charset=utf8mb4",
            $db_config['username'],
            $db_config['password'],
            [
                PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION,
                PDO::ATTR_DEFAULT_FETCH_MODE => PDO::FETCH_ASSOC
            ]
        );
        return $pdo;
    } catch (PDOException $e) {
        die("Database connection failed: " . $e->getMessage());
    }
    }
}
?>
