<?= $this->extend('layouts/app') ?>

<?= $this->section('content') ?>
<div class="container">
    <div class="row justify-content-center py-5">
        <div class="col-md-8 col-lg-7">
            <div class="card card-custom">
                <div class="card-body p-5">
                    <!-- Header -->
                    <div class="text-center mb-4">
                        <div class="mb-3">
                            <i class="fas fa-user-plus fa-3x text-primary"></i>
                        </div>
                        <h3 class="card-title fw-bold text-primary">Registrasi Pemohon</h3>
                        <p class="text-muted">Daftar untuk mengajukan permohonan salinan putusan</p>
                    </div>

                    <!-- Registration Form -->
                    <?= form_open_multipart('/register', ['class' => 'needs-validation', 'novalidate' => true]) ?>
                        
                        <!-- Step 1: Account Information -->
                        <div class="mb-4">
                            <h5 class="text-primary mb-3">
                                <i class="fas fa-user-circle me-2"></i>Informasi Akun
                            </h5>
                            
                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="username" class="form-label">Username *</label>
                                    <input type="text" 
                                           class="form-control <?= session('errors.username') ? 'is-invalid' : '' ?>" 
                                           id="username" 
                                           name="username" 
                                           value="<?= old('username') ?>" 
                                           placeholder="Username untuk login"
                                           required>
                                    <?php if (session('errors.username')): ?>
                                        <div class="invalid-feedback">
                                            <?= session('errors.username') ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                
                                <div class="col-md-6 mb-3">
                                    <label for="email" class="form-label">Email *</label>
                                    <input type="email" 
                                           class="form-control <?= session('errors.email') ? 'is-invalid' : '' ?>" 
                                           id="email" 
                                           name="email" 
                                           value="<?= old('email') ?>" 
                                           placeholder="email@example.com"
                                           required>
                                    <?php if (session('errors.email')): ?>
                                        <div class="invalid-feedback">
                                            <?= session('errors.email') ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="password" class="form-label">Password *</label>
                                    <div class="input-group">
                                        <input type="password" 
                                               class="form-control <?= session('errors.password') ? 'is-invalid' : '' ?>" 
                                               id="password" 
                                               name="password" 
                                               placeholder="Minimal 6 karakter"
                                               minlength="6"
                                               required>
                                        <button class="btn btn-outline-secondary" type="button" id="togglePassword">
                                            <i class="fas fa-eye" id="eyeIcon"></i>
                                        </button>
                                        <?php if (session('errors.password')): ?>
                                            <div class="invalid-feedback">
                                                <?= session('errors.password') ?>
                                            </div>
                                        <?php endif; ?>
                                    </div>
                                </div>
                                
                                <div class="col-md-6 mb-3">
                                    <label for="confirm_password" class="form-label">Konfirmasi Password *</label>
                                    <input type="password" 
                                           class="form-control <?= session('errors.confirm_password') ? 'is-invalid' : '' ?>" 
                                           id="confirm_password" 
                                           name="confirm_password" 
                                           placeholder="Ulangi password"
                                           required>
                                    <?php if (session('errors.confirm_password')): ?>
                                        <div class="invalid-feedback">
                                            <?= session('errors.confirm_password') ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>
                        </div>

                        <!-- Step 2: Personal Information -->
                        <div class="mb-4">
                            <h5 class="text-primary mb-3">
                                <i class="fas fa-id-card me-2"></i>Informasi Pribadi
                            </h5>
                            
                            <div class="mb-3">
                                <label for="nama_lengkap" class="form-label">Nama Lengkap *</label>
                                <input type="text" 
                                       class="form-control <?= session('errors.nama_lengkap') ? 'is-invalid' : '' ?>" 
                                       id="nama_lengkap" 
                                       name="nama_lengkap" 
                                       value="<?= old('nama_lengkap') ?>" 
                                       placeholder="Nama lengkap sesuai KTP"
                                       required>
                                <?php if (session('errors.nama_lengkap')): ?>
                                    <div class="invalid-feedback">
                                        <?= session('errors.nama_lengkap') ?>
                                    </div>
                                <?php endif; ?>
                            </div>

                            <div class="row">
                                <div class="col-md-6 mb-3">
                                    <label for="nik" class="form-label">NIK (Nomor Induk Kependudukan) *</label>
                                    <input type="text" 
                                           class="form-control <?= session('errors.nik') ? 'is-invalid' : '' ?>" 
                                           id="nik" 
                                           name="nik" 
                                           value="<?= old('nik') ?>" 
                                           placeholder="16 digit NIK"
                                           maxlength="16"
                                           pattern="[0-9]{16}"
                                           required>
                                    <?php if (session('errors.nik')): ?>
                                        <div class="invalid-feedback">
                                            <?= session('errors.nik') ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                                
                                <div class="col-md-6 mb-3">
                                    <label for="no_telepon" class="form-label">Nomor Telepon *</label>
                                    <input type="tel" 
                                           class="form-control <?= session('errors.no_telepon') ? 'is-invalid' : '' ?>" 
                                           id="no_telepon" 
                                           name="no_telepon" 
                                           value="<?= old('no_telepon') ?>" 
                                           placeholder="081234567890"
                                           required>
                                    <?php if (session('errors.no_telepon')): ?>
                                        <div class="invalid-feedback">
                                            <?= session('errors.no_telepon') ?>
                                        </div>
                                    <?php endif; ?>
                                </div>
                            </div>

                            <div class="mb-3">
                                <label for="alamat" class="form-label">Alamat Lengkap *</label>
                                <textarea class="form-control <?= session('errors.alamat') ? 'is-invalid' : '' ?>" 
                                          id="alamat" 
                                          name="alamat" 
                                          rows="3" 
                                          placeholder="Alamat lengkap sesuai KTP"
                                          required><?= old('alamat') ?></textarea>
                                <?php if (session('errors.alamat')): ?>
                                    <div class="invalid-feedback">
                                        <?= session('errors.alamat') ?>
                                    </div>
                                <?php endif; ?>
                            </div>
                        </div>

                        <!-- Step 3: Document Upload -->
                        <div class="mb-4">
                            <h5 class="text-primary mb-3">
                                <i class="fas fa-upload me-2"></i>Upload Dokumen
                            </h5>
                            
                            <div class="mb-3">
                                <label for="ktp_file" class="form-label">File KTP *</label>
                                <input type="file" 
                                       class="form-control <?= session('errors.ktp_file') ? 'is-invalid' : '' ?>" 
                                       id="ktp_file" 
                                       name="ktp_file" 
                                       accept=".pdf,.jpg,.jpeg,.png"
                                       required>
                                <div class="form-text">
                                    Format yang diperbolehkan: PDF, JPG, JPEG, PNG. Maksimal 5MB.
                                </div>
                                <?php if (session('errors.ktp_file')): ?>
                                    <div class="invalid-feedback">
                                        <?= session('errors.ktp_file') ?>
                                    </div>
                                <?php endif; ?>
                            </div>

                            <!-- File Preview -->
                            <div id="file-preview" class="mt-3" style="display: none;">
                                <div class="card border-success">
                                    <div class="card-body">
                                        <h6 class="card-title text-success">
                                            <i class="fas fa-check-circle me-2"></i>File Terpilih
                                        </h6>
                                        <p class="card-text mb-0" id="file-info"></p>
                                    </div>
                                </div>
                            </div>
                        </div>

                        <!-- Terms and Conditions -->
                        <div class="mb-4">
                            <div class="form-check">
                                <input class="form-check-input" type="checkbox" id="terms" name="terms" required>
                                <label class="form-check-label" for="terms">
                                    Saya menyatakan bahwa data yang saya isi adalah <strong>benar dan dapat dipertanggungjawabkan</strong>. Saya memahami bahwa memberikan data palsu dapat dikenakan sanksi hukum.
                                </label>
                                <div class="invalid-feedback">
                                    Anda harus menyetujui pernyataan ini.
                                </div>
                            </div>
                        </div>

                        <!-- Submit Button -->
                        <div class="d-grid gap-2">
                            <button type="submit" class="btn btn-primary btn-custom btn-lg">
                                <i class="fas fa-user-plus me-2"></i> Daftar Sekarang
                            </button>
                        </div>

                    <?= form_close() ?>

                    <!-- Login Link -->
                    <hr class="my-4">
                    <div class="text-center">
                        <p class="mb-0">Sudah memiliki akun? 
                            <a href="/login" class="text-decoration-none">
                                <i class="fas fa-sign-in-alt me-1"></i>Login di sini
                            </a>
                        </p>
                    </div>
                </div>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script>
    // Toggle password visibility
    document.getElementById('togglePassword').addEventListener('click', function() {
        const passwordField = document.getElementById('password');
        const eyeIcon = document.getElementById('eyeIcon');
        
        if (passwordField.type === 'password') {
            passwordField.type = 'text';
            eyeIcon.classList.remove('fa-eye');
            eyeIcon.classList.add('fa-eye-slash');
        } else {
            passwordField.type = 'password';
            eyeIcon.classList.remove('fa-eye-slash');
            eyeIcon.classList.add('fa-eye');
        }
    });

    // Password confirmation validation
    document.getElementById('confirm_password').addEventListener('input', function() {
        const password = document.getElementById('password').value;
        const confirmPassword = this.value;
        
        if (password !== confirmPassword) {
            this.setCustomValidity('Password tidak sama');
        } else {
            this.setCustomValidity('');
        }
    });

    // NIK validation (only numbers)
    document.getElementById('nik').addEventListener('input', function() {
        this.value = this.value.replace(/[^0-9]/g, '');
        if (this.value.length !== 16) {
            this.setCustomValidity('NIK harus terdiri dari 16 digit');
        } else {
            this.setCustomValidity('');
        }
    });

    // Phone number validation
    document.getElementById('no_telepon').addEventListener('input', function() {
        this.value = this.value.replace(/[^0-9]/g, '');
    });

    // File upload preview
    document.getElementById('ktp_file').addEventListener('change', function() {
        const file = this.files[0];
        const preview = document.getElementById('file-preview');
        const fileInfo = document.getElementById('file-info');
        
        if (file) {
            const fileSize = formatFileSize(file.size);
            const fileName = file.name;
            
            fileInfo.innerHTML = `
                <strong>Nama File:</strong> ${fileName}<br>
                <strong>Ukuran:</strong> ${fileSize}<br>
                <strong>Tipe:</strong> ${file.type}
            `;
            preview.style.display = 'block';
            
            // Validate file size (5MB = 5 * 1024 * 1024 bytes)
            if (file.size > 5 * 1024 * 1024) {
                this.setCustomValidity('Ukuran file tidak boleh lebih dari 5MB');
            } else {
                this.setCustomValidity('');
            }
        } else {
            preview.style.display = 'none';
        }
    });

    // Form validation
    (function() {
        'use strict';
        window.addEventListener('load', function() {
            var forms = document.getElementsByClassName('needs-validation');
            var validation = Array.prototype.filter.call(forms, function(form) {
                form.addEventListener('submit', function(event) {
                    if (form.checkValidity() === false) {
                        event.preventDefault();
                        event.stopPropagation();
                    }
                    form.classList.add('was-validated');
                }, false);
            });
        }, false);
    })();
</script>
<?= $this->endSection() ?>
