<?= $this->extend('layouts/app') ?>

<?= $this->section('content') ?>
<div class="container-fluid">
    <div class="d-sm-flex align-items-center justify-content-between mb-4">
        <h1 class="h3 mb-0 text-gray-800">
            <i class="fas fa-tachometer-alt me-2"></i>Dashboard Admin
        </h1>
        <div class="d-sm-flex">
            <span class="badge bg-primary px-3 py-2">
                <i class="fas fa-calendar me-1"></i>
                <?= date('d F Y, H:i') ?> WIB
            </span>
        </div>
    </div>

    <!-- Statistics Cards Row -->
    <div class="row">
        <!-- Users Statistics -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-primary shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-primary text-uppercase mb-1">
                                Total Users
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                <?= $stats['users']['total'] ?>
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-users fa-2x text-gray-300"></i>
                        </div>
                    </div>
                    <small class="text-muted">
                        <i class="fas fa-user-shield"></i> Admin: <?= $stats['users']['admin'] ?> |
                        <i class="fas fa-user-tie"></i> Petugas: <?= $stats['users']['petugas'] ?> |
                        <i class="fas fa-user"></i> Pemohon: <?= $stats['users']['pemohon'] ?>
                    </small>
                </div>
            </div>
        </div>

        <!-- Pemohon Statistics -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-success shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-success text-uppercase mb-1">
                                Pemohon Verified
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                <?= $stats['pemohon']['verified'] ?>
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-user-check fa-2x text-gray-300"></i>
                        </div>
                    </div>
                    <small class="text-muted">
                        <i class="fas fa-clock text-warning"></i> Pending: <?= $stats['pemohon']['pending'] ?> |
                        <i class="fas fa-times text-danger"></i> Rejected: <?= $stats['pemohon']['rejected'] ?>
                    </small>
                </div>
            </div>
        </div>

        <!-- Permohonan Statistics -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-info shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-info text-uppercase mb-1">
                                Total Permohonan
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                <?= $stats['permohonan']['total'] ?>
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-file-alt fa-2x text-gray-300"></i>
                        </div>
                    </div>
                    <small class="text-muted">
                        <i class="fas fa-check text-success"></i> Selesai: <?= $stats['permohonan']['selesai'] ?> |
                        <i class="fas fa-spinner text-primary"></i> Diproses: <?= $stats['permohonan']['diproses'] ?>
                    </small>
                </div>
            </div>
        </div>

        <!-- Monthly Permohonan -->
        <div class="col-xl-3 col-md-6 mb-4">
            <div class="card border-left-warning shadow h-100 py-2">
                <div class="card-body">
                    <div class="row no-gutters align-items-center">
                        <div class="col mr-2">
                            <div class="text-xs font-weight-bold text-warning text-uppercase mb-1">
                                Permohonan Bulan Ini
                            </div>
                            <div class="h5 mb-0 font-weight-bold text-gray-800">
                                <?= $stats['permohonan']['monthly'][date('n')] ?>
                            </div>
                        </div>
                        <div class="col-auto">
                            <i class="fas fa-calendar-alt fa-2x text-gray-300"></i>
                        </div>
                    </div>
                    <small class="text-muted">
                        <i class="fas fa-chart-line"></i> Trend bulanan
                    </small>
                </div>
            </div>
        </div>
    </div>

    <div class="row">
        <!-- Recent Permohonan -->
        <div class="col-xl-8 col-lg-7">
            <div class="card shadow mb-4">
                <div class="card-header py-3 d-flex flex-row align-items-center justify-content-between">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="fas fa-file-alt me-2"></i>Permohonan Terbaru
                    </h6>
                    <a href="/admin/permohonans" class="btn btn-primary btn-sm">
                        <i class="fas fa-list me-1"></i>Lihat Semua
                    </a>
                </div>
                <div class="card-body">
                    <?php if (empty($recent_permohonans)): ?>
                        <div class="text-center py-4">
                            <i class="fas fa-inbox fa-3x text-gray-300 mb-3"></i>
                            <p class="text-muted">Belum ada permohonan</p>
                        </div>
                    <?php else: ?>
                        <div class="table-responsive">
                            <table class="table table-borderless">
                                <thead>
                                    <tr>
                                        <th>Tanggal</th>
                                        <th>Pemohon</th>
                                        <th>Nomor Perkara</th>
                                        <th>Status</th>
                                        <th>Aksi</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <?php foreach ($recent_permohonans as $permohonan): ?>
                                        <tr>
                                            <td>
                                                <small class="text-muted">
                                                    <?= date('d/m/Y', strtotime($permohonan['created_at'])) ?>
                                                </small>
                                            </td>
                                            <td>
                                                <strong><?= esc($permohonan['nama_lengkap'] ?? $permohonan['username']) ?></strong><br>
                                                <small class="text-muted"><?= esc($permohonan['email']) ?></small>
                                            </td>
                                            <td>
                                                <code><?= esc($permohonan['nomor_perkara']) ?></code><br>
                                                <small class="text-muted"><?= esc($permohonan['nama_terdakwa']) ?></small>
                                            </td>
                                            <td>
                                                <?php
                                                $statusClass = [
                                                    'pending' => 'bg-warning',
                                                    'diterima' => 'bg-info',
                                                    'diproses' => 'bg-primary',
                                                    'selesai' => 'bg-success',
                                                    'ditolak' => 'bg-danger'
                                                ];
                                                ?>
                                                <span class="badge <?= $statusClass[$permohonan['status']] ?? 'bg-secondary' ?> status-badge">
                                                    <?= ucfirst($permohonan['status']) ?>
                                                </span>
                                            </td>
                                            <td>
                                                <a href="/admin/permohonans/<?= $permohonan['id'] ?>" class="btn btn-sm btn-outline-primary">
                                                    <i class="fas fa-eye"></i>
                                                </a>
                                            </td>
                                        </tr>
                                    <?php endforeach; ?>
                                </tbody>
                            </table>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Pending Verifications -->
        <div class="col-xl-4 col-lg-5">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="fas fa-user-clock me-2"></i>Menunggu Verifikasi
                    </h6>
                </div>
                <div class="card-body">
                    <?php if (empty($pending_verifications)): ?>
                        <div class="text-center py-4">
                            <i class="fas fa-check-circle fa-3x text-success mb-3"></i>
                            <p class="text-muted">Semua akun sudah diverifikasi</p>
                        </div>
                    <?php else: ?>
                        <?php foreach ($pending_verifications as $pending): ?>
                            <div class="d-flex align-items-center mb-3 p-3 bg-light rounded">
                                <div class="flex-shrink-0">
                                    <div class="avatar bg-primary text-white rounded-circle d-flex align-items-center justify-content-center" style="width: 40px; height: 40px;">
                                        <i class="fas fa-user"></i>
                                    </div>
                                </div>
                                <div class="flex-grow-1 ms-3">
                                    <h6 class="mb-1"><?= esc($pending['nama_lengkap']) ?></h6>
                                    <p class="mb-1 text-muted small"><?= esc($pending['email']) ?></p>
                                    <small class="text-muted">
                                        <i class="fas fa-clock me-1"></i>
                                        <?= date('d/m/Y H:i', strtotime($pending['registered_at'])) ?>
                                    </small>
                                </div>
                                <div class="flex-shrink-0">
                                    <a href="/petugas/verifikasi" class="btn btn-sm btn-outline-primary">
                                        <i class="fas fa-check"></i>
                                    </a>
                                </div>
                            </div>
                        <?php endforeach; ?>
                        
                        <?php if (count($pending_verifications) > 3): ?>
                            <div class="text-center">
                                <a href="/petugas/verifikasi" class="btn btn-sm btn-link">
                                    Lihat semua (<?= count($pending_verifications) ?> total)
                                </a>
                            </div>
                        <?php endif; ?>
                    <?php endif; ?>
                </div>
            </div>

            <!-- Quick Actions -->
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="fas fa-bolt me-2"></i>Quick Actions
                    </h6>
                </div>
                <div class="card-body">
                    <div class="list-group list-group-flush">
                        <a href="/admin/users/create" class="list-group-item list-group-item-action d-flex align-items-center">
                            <i class="fas fa-user-plus text-primary me-3"></i>
                            <div>
                                <h6 class="mb-1">Tambah User Baru</h6>
                                <small class="text-muted">Buat akun admin atau petugas</small>
                            </div>
                        </a>
                        <a href="/admin/permohonans" class="list-group-item list-group-item-action d-flex align-items-center">
                            <i class="fas fa-file-alt text-info me-3"></i>
                            <div>
                                <h6 class="mb-1">Kelola Permohonan</h6>
                                <small class="text-muted">Lihat dan kelola semua permohonan</small>
                            </div>
                        </a>
                        <a href="/admin/users" class="list-group-item list-group-item-action d-flex align-items-center">
                            <i class="fas fa-users text-success me-3"></i>
                            <div>
                                <h6 class="mb-1">Kelola Users</h6>
                                <small class="text-muted">Kelola akun pengguna sistem</small>
                            </div>
                        </a>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Monthly Chart -->
    <div class="row">
        <div class="col-xl-12">
            <div class="card shadow mb-4">
                <div class="card-header py-3">
                    <h6 class="m-0 font-weight-bold text-primary">
                        <i class="fas fa-chart-area me-2"></i>Statistik Permohonan Bulanan <?= date('Y') ?>
                    </h6>
                </div>
                <div class="card-body">
                    <canvas id="monthlyChart" width="100%" height="30"></canvas>
                </div>
            </div>
        </div>
    </div>
</div>
<?= $this->endSection() ?>

<?= $this->section('head') ?>
<style>
    .border-left-primary {
        border-left: 0.25rem solid #4e73df !important;
    }
    .border-left-success {
        border-left: 0.25rem solid #1cc88a !important;
    }
    .border-left-info {
        border-left: 0.25rem solid #36b9cc !important;
    }
    .border-left-warning {
        border-left: 0.25rem solid #f6c23e !important;
    }
    .avatar {
        width: 40px;
        height: 40px;
        font-size: 0.875rem;
    }
</style>
<?= $this->endSection() ?>

<?= $this->section('scripts') ?>
<script src="https://cdn.jsdelivr.net/npm/chart.js"></script>
<script>
    // Monthly Chart
    const monthlyData = <?= json_encode(array_values($stats['permohonan']['monthly'])) ?>;
    const monthNames = ['Jan', 'Feb', 'Mar', 'Apr', 'May', 'Jun', 'Jul', 'Aug', 'Sep', 'Oct', 'Nov', 'Dec'];
    
    const ctx = document.getElementById('monthlyChart').getContext('2d');
    const monthlyChart = new Chart(ctx, {
        type: 'line',
        data: {
            labels: monthNames,
            datasets: [{
                label: 'Jumlah Permohonan',
                data: monthlyData,
                borderColor: '#4e73df',
                backgroundColor: 'rgba(78, 115, 223, 0.1)',
                borderWidth: 2,
                fill: true,
                tension: 0.3
            }]
        },
        options: {
            responsive: true,
            plugins: {
                legend: {
                    display: false
                }
            },
            scales: {
                y: {
                    beginAtZero: true,
                    ticks: {
                        stepSize: 1
                    }
                }
            }
        }
    });

    // Auto refresh statistics every 5 minutes
    setInterval(function() {
        location.reload();
    }, 300000);
</script>
<?= $this->endSection() ?>
