<?php

namespace App\Database\Migrations;

use CodeIgniter\Database\Migration;

class CreatePermohonansTable extends Migration
{
    public function up()
    {
        $this->forge->addField([
            'id' => [
                'type'           => 'INT',
                'constraint'     => 11,
                'unsigned'       => true,
                'auto_increment' => true,
            ],
            'user_id' => [
                'type'       => 'INT',
                'constraint' => 11,
                'unsigned'   => true,
            ],
            'nomor_perkara' => [
                'type'       => 'VARCHAR',
                'constraint' => 100,
            ],
            'nama_terdakwa' => [
                'type'       => 'VARCHAR',
                'constraint' => 255,
            ],
            'tujuan_permohonan' => [
                'type' => 'TEXT',
            ],
            'status' => [
                'type'       => 'ENUM',
                'constraint' => ['pending', 'diterima', 'diproses', 'selesai', 'ditolak'],
                'default'    => 'pending',
            ],
            'catatan_internal' => [
                'type' => 'TEXT',
                'null' => true,
            ],
            'catatan_pemohon' => [
                'type' => 'TEXT',
                'null' => true,
            ],
            'processed_by' => [
                'type'       => 'INT',
                'constraint' => 11,
                'unsigned'   => true,
                'null'       => true,
            ],
            'processed_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'pdf_generated_path' => [
                'type'       => 'VARCHAR',
                'constraint' => 255,
                'null'       => true,
            ],
            'created_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
            'updated_at' => [
                'type' => 'DATETIME',
                'null' => true,
            ],
        ]);
        
        $this->forge->addKey('id', true);
        $this->forge->addKey(['user_id']);
        $this->forge->addKey(['nomor_perkara']);
        $this->forge->addKey(['status']);
        
        $this->forge->addForeignKey('user_id', 'users', 'id', 'CASCADE', 'CASCADE');
        $this->forge->addForeignKey('processed_by', 'users', 'id', 'SET NULL', 'CASCADE');
        
        $this->forge->createTable('permohonans');
    }

    public function down()
    {
        $this->forge->dropTable('permohonans');
    }
}
