# LANGKAH PERBAIKAN ERROR DATABASE

## ❌ Error yang Terjadi:
```
Database connection failed: SQLSTATE[HY000] [1045] Access denied for user 'root'@'localhost' (using password: NO)
```

## ✅ Solusi yang Sudah Dilakukan:

### 1. Update Konfigurasi Database
File yang sudah diupdate dengan konfigurasi hosting RumahWeb:
- ✅ `create_tables.php` 
- ✅ `public/setup.php`
- ✅ `public/print-permohonan.php`
- ✅ `test_db_connection.php` (file baru untuk test)

### 2. Konfigurasi Baru:
```php
$config = [
    'host' => 'localhost',
    'database' => 'pnwy4699_permohonan',
    'username' => 'pnwy4699_dbuser', 
    'password' => 'permohonan-salinan-putusan'
];
```

## 🔧 Langkah Selanjutnya:

### 1. Upload File ke Hosting
Upload file `test_db_connection.php` ke root folder hosting dan akses:
```
https://pnwtp.site/test_db_connection.php
```

### 2. Jika Test Koneksi Berhasil
Akses untuk membuat tabel database:
```
https://pnwtp.site/create_tables.php
```

### 3. Jika Masih Error, Cek di cPanel:
1. **MySQL Databases** → Pastikan database `pnwy4699_permohonan` ada
2. **MySQL Users** → Pastikan user `pnwy4699_dbuser` ada  
3. **Current Databases** → Pastikan user sudah di-assign ke database
4. **User Privileges** → Pastikan punya ALL PRIVILEGES

### 4. Alternative: Buat Database Baru
Jika masih error, buat database baru:
1. Database name: `permohonan` (akan jadi `pnwy4699_permohonan`)
2. User: `appuser` (akan jadi `pnwy4699_appuser`)
3. Password: buat yang baru
4. Update semua file PHP dengan konfigurasi baru

## 📞 Jika Masih Bermasalah:
- Hubungi Support RumahWeb via live chat
- Minta bantuan setup database MySQL
- Berikan detail error yang terjadi

---
*Update: File konfigurasi sudah diperbaiki untuk hosting RumahWeb*
