# 🎯 CARA AKSES APLIKASI PERMOHONAN SALINAN PUTUSAN

## 📋 URL Akses yang Tersedia

### 🚀 **URL UTAMA (Recommended)**
```
http://localhost/permohonan-salinan-putusan/
```
✅ **Ini adalah cara termudah untuk mengakses aplikasi**

### 🔗 **URL Alternatif**
```
http://localhost/permohonan-salinan-putusan/public/setup.php
```
✅ **URL langsung ke file utama aplikasi**

### 🌐 **Jika menggunakan port 8080**
```
http://localhost:8080/permohonan-salinan-putusan/
```
atau
```
http://localhost:8080/permohonan-salinan-putusan/public/setup.php
```

---

## 🏠 **Navigasi Halaman**

### 📱 **Halaman Publik**
- **Homepage**: `http://localhost/permohonan-salinan-putusan/`
- **Login**: `http://localhost/permohonan-salinan-putusan/?page=login`
- **Registrasi**: `http://localhost/permohonan-salinan-putusan/?page=register`

### 🔐 **Halaman Setelah Login**
- **Dashboard**: `http://localhost/permohonan-salinan-putusan/?page=dashboard`
- **Verifikasi** (Petugas/Admin): `http://localhost/permohonan-salinan-putusan/?page=verifikasi`
- **Permohonan Baru** (Pemohon): `http://localhost/permohonan-salinan-putusan/?page=permohonan-baru`
- **Permohonan Saya** (Pemohon): `http://localhost/permohonan-salinan-putusan/?page=permohonan-saya`

---

## 👥 **Akun Demo untuk Testing**

### 👨‍💼 **ADMIN**
- **Login**: `admin` atau `admin@pn-watampone.go.id`
- **Password**: `password`
- **Akses**: Full access ke semua fitur

### 👮‍♀️ **PETUGAS**
- **Login**: `petugas1` atau `petugas1@pn-watampone.go.id`
- **Password**: `password`
- **Akses**: Verifikasi akun, manajemen permohonan

### 👤 **PEMOHON (Verified)**
- **Login**: `pemohon_demo` atau `pemohon@example.com` atau `081234567890`
- **Password**: `password`
- **Akses**: Buat permohonan salinan putusan

### 👤 **PEMOHON CUSTOM**
- **Login**: `fahrul` atau `fahrul@gmail.com` atau `082292215424`
- **Password**: `12345678`
- **Akses**: Buat permohonan salinan putusan

---

## 🛠️ **Setup Server (Jika Diperlukan)**

### 📁 **Struktur Direktori**
```
C:\xampp\htdocs\permohonan-salinan-putusan\
├── index.php                 (Entry point utama)
├── .htaccess                 (Apache configuration)
├── public\
│   ├── setup.php            (Main application)
│   ├── login.php
│   ├── register.php
│   ├── dashboard.php
│   └── ...
├── writable\
│   └── uploads\             (File storage)
└── README.md
```

### ⚙️ **Apache Configuration**
File `.htaccess` sudah dikonfigurasi untuk:
- ✅ URL rewriting
- ✅ Security headers
- ✅ File compression
- ✅ Cache optimization

### 🗄️ **Database**
- **Database**: `permohonan_salinan_putusan`
- **Host**: `localhost`
- **Username**: `root`
- **Password**: (kosong)

---

## 🚀 **Quick Start**

1. **Buka browser**
2. **Akses**: `http://localhost/permohonan-salinan-putusan/`
3. **Klik "Login"**
4. **Gunakan salah satu akun demo di atas**
5. **Mulai eksplorasi fitur aplikasi!**

---

## 🔧 **Troubleshooting**

### ❌ **Jika URL tidak bisa diakses:**
1. Pastikan XAMPP Apache sudah running
2. Pastikan folder ada di `C:\xampp\htdocs\`
3. Coba akses langsung: `http://localhost/permohonan-salinan-putusan/public/setup.php`

### ❌ **Jika database error:**
1. Pastikan MySQL sudah running
2. Import database menggunakan phpMyAdmin
3. Check koneksi di file konfigurasi

### ❌ **Jika file upload error:**
1. Pastikan direktori `writable/uploads/` ada
2. Set permission direktori (chmod 777 di Linux)
3. Check PHP upload settings

---

## 📞 **Support**

Jika ada masalah atau pertanyaan:
- 📧 **Email**: admin@pn-watampone.go.id
- 📱 **Demo**: Gunakan akun demo untuk testing
- 🔧 **Development**: Check browser console untuk error debugging

---

✨ **Aplikasi Permohonan Salinan Putusan siap digunakan!** ✨
