<?php
/**
 * Database Test
 */

echo "<h2>Database Connection Test</h2>";

try {
    // Test basic database connection
    $db_path = __DIR__ . '/database/siskim.db';
    echo "Database path: $db_path<br>";
    echo "File exists: " . (file_exists($db_path) ? 'Yes' : 'No') . "<br>";
    echo "File writable: " . (is_writable(dirname($db_path)) ? 'Yes' : 'No') . "<br><br>";
    
    $pdo = new PDO('sqlite:' . $db_path);
    $pdo->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
    echo "✓ PDO Connection successful<br><br>";
    
    // Test tables
    $tables = ['users', 'permission_types', 'permissions', 'settings'];
    foreach ($tables as $table) {
        try {
            $stmt = $pdo->query("SELECT COUNT(*) FROM $table");
            $count = $stmt->fetchColumn();
            echo "✓ Table '$table': $count records<br>";
        } catch (Exception $e) {
            echo "✗ Table '$table': " . $e->getMessage() . "<br>";
        }
    }
    
    echo "<br><h3>Sample Users:</h3>";
    $stmt = $pdo->query("SELECT nip, name, role FROM users LIMIT 5");
    while ($row = $stmt->fetch()) {
        echo "- {$row['name']} ({$row['nip']}) - {$row['role']}<br>";
    }
    
} catch (Exception $e) {
    echo "✗ Error: " . $e->getMessage();
}

echo "<br><br><a href='index.php'>Go to Main Page</a>";
?>