<?php
require_once 'config/config.php';

// Redirect jika sudah login
if ($auth->isLoggedIn()) {
    redirect('dashboard.php');
}

$error_message = '';
$success_message = '';

// Handle form submission
if ($_POST) {
    if (!validateCSRFToken($_POST['csrf_token'] ?? '')) {
        $error_message = 'Token keamanan tidak valid';
    } else {
        $nip = sanitize($_POST['nip'] ?? '');
        $password = $_POST['password'] ?? '';
        
        if (empty($nip) || empty($password)) {
            $error_message = 'NIP dan password harus diisi';
        } else {
            $login_result = $auth->login($nip, $password);
            
            if ($login_result['success']) {
                redirect('dashboard.php', 'Login berhasil!');
            } else {
                $error_message = $login_result['message'];
            }
        }
    }
}

$csrf_token = generateCSRFToken();
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Login - SISKIM PN Watampone</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <script src="https://cdn.jsdelivr.net/npm/feather-icons/dist/feather.min.js"></script>
    <script src="https://unpkg.com/feather-icons"></script>
    <style>
        .login-bg {
            background-image: linear-gradient(rgba(30, 58, 138, 0.9), rgba(30, 58, 138, 0.9)), url('<?php echo getImagePath('gedung-pn-wtp.png'); ?>');
            background-size: cover;
            background-position: center;
        }
    </style>
</head>
<body class="bg-gray-50">
    <div class="min-h-screen flex items-center justify-center p-4 login-bg">
        <div class="w-full max-w-md bg-white rounded-xl shadow-lg overflow-hidden">
            <div class="bg-blue-900 py-4 px-6">
                <div class="flex items-center space-x-2">
                    <?php echo getLogoHtml('w-10 h-10 rounded bg-white p-1'); ?>
                    <div>
                        <h2 class="text-xl font-bold text-white">SISKIM</h2>
                        <p class="text-xs text-blue-200">Pengadilan Negeri Watampone</p>
                    </div>
                </div>
            </div>
            <div class="p-6">
                <h1 class="text-2xl font-bold text-gray-800 mb-2">Masuk ke Akun</h1>
                <p class="text-sm text-gray-600 mb-6">Silakan masuk menggunakan NIP dan password Anda</p>
                
                <?php if ($error_message): ?>
                <div class="bg-red-100 border border-red-400 text-red-700 px-4 py-3 rounded mb-4" role="alert">
                    <div class="flex items-center">
                        <i data-feather="alert-circle" class="w-5 h-5 mr-2"></i>
                        <span><?php echo escape($error_message); ?></span>
                    </div>
                </div>
                <?php endif; ?>
                
                <?php if ($success_message): ?>
                <div class="bg-green-100 border border-green-400 text-green-700 px-4 py-3 rounded mb-4" role="alert">
                    <div class="flex items-center">
                        <i data-feather="check-circle" class="w-5 h-5 mr-2"></i>
                        <span><?php echo escape($success_message); ?></span>
                    </div>
                </div>
                <?php endif; ?>
                
                <form method="POST" action="">
                    <input type="hidden" name="csrf_token" value="<?php echo $csrf_token; ?>">
                    
                    <div class="mb-4">
                        <label for="nip" class="block text-sm font-medium text-gray-700 mb-1">NIP/NIK</label>
                        <div class="relative">
                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                <i data-feather="user" class="h-5 w-5 text-gray-400"></i>
                            </div>
                            <input 
                                type="text" 
                                id="nip" 
                                name="nip" 
                                value="<?php echo escape($_POST['nip'] ?? ''); ?>"
                                class="block w-full pl-10 pr-3 py-2 border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500" 
                                placeholder="Masukkan NIP/NIK"
                                required
                                autocomplete="username"
                            >
                        </div>
                    </div>
                    
                    <div class="mb-6">
                        <label for="password" class="block text-sm font-medium text-gray-700 mb-1">Password</label>
                        <div class="relative">
                            <div class="absolute inset-y-0 left-0 pl-3 flex items-center pointer-events-none">
                                <i data-feather="lock" class="h-5 w-5 text-gray-400"></i>
                            </div>
                            <input 
                                type="password" 
                                id="password" 
                                name="password" 
                                class="block w-full pl-10 pr-3 py-2 border border-gray-300 rounded-lg shadow-sm focus:outline-none focus:ring-blue-500 focus:border-blue-500" 
                                placeholder="Masukkan password"
                                required
                                autocomplete="current-password"
                            >
                        </div>
                    </div>
                    
                    <div class="flex items-center justify-between mb-6">
                        <div class="flex items-center">
                            <input id="remember-me" name="remember-me" type="checkbox" class="h-4 w-4 text-blue-600 focus:ring-blue-500 border-gray-300 rounded">
                            <label for="remember-me" class="ml-2 block text-sm text-gray-700">Ingat saya</label>
                        </div>
                        <div class="text-sm">
                            <a href="#" class="font-medium text-blue-600 hover:text-blue-500">Lupa password?</a>
                        </div>
                    </div>
                    
                    <button type="submit" class="w-full flex justify-center py-2 px-4 border border-transparent rounded-lg shadow-sm text-sm font-medium text-white bg-blue-600 hover:bg-blue-700 focus:outline-none focus:ring-2 focus:ring-offset-2 focus:ring-blue-500">
                        Masuk
                    </button>
                </form>
                
                <div class="mt-6 text-center">
                    <div class="text-xs text-gray-500">
                        Demo Login:<br>
                        <strong>Admin:</strong> admin / admin123<br>
                        <strong>User:</strong> 199606192025062007 / 123456
                    </div>
                </div>
            </div>
            <div class="px-6 py-4 bg-gray-50 border-t border-gray-200">
                <p class="text-xs text-gray-500 text-center">© 2025 Pengadilan Negeri Watampone. All rights reserved.</p>
            </div>
        </div>
    </div>

    <script>
        feather.replace();
    </script>
</body>
</html>