<?php
/**
 * Header Component
 * SISKIM - Sistem Izin Keluar Masuk
 */

// Ambil user data
$current_user = $auth->getCurrentUser();
?>
<header class="bg-white shadow-sm p-4 flex justify-between items-center">
    <div class="flex items-center space-x-4">
        <button class="md:hidden" onclick="toggleSidebar()">
            <i data-feather="menu" class="w-6 h-6 text-gray-600"></i>
        </button>
        <div class="flex items-center space-x-3">
            <?php echo getLogoHtml('h-8'); ?>
            <h1 class="text-xl font-semibold text-gray-800"><?php echo escape($page_title ?? 'Dashboard'); ?></h1>
        </div>
    </div>
    <div class="flex items-center space-x-4">
        <div class="relative">
            <button onclick="toggleNotifications()" class="relative">
                <i data-feather="bell" class="w-6 h-6 text-gray-600"></i>
                <span id="notification-badge" class="absolute top-0 right-0 w-2 h-2 bg-red-500 rounded-full hidden"></span>
            </button>
            <!-- Notification dropdown -->
            <div id="notification-dropdown" class="hidden absolute right-0 mt-2 w-80 bg-white rounded-lg shadow-lg border z-50">
                <div class="p-4 border-b">
                    <h3 class="font-semibold text-gray-800">Notifikasi</h3>
                </div>
                <div class="p-4">
                    <p class="text-sm text-gray-500 text-center">Tidak ada notifikasi baru</p>
                </div>
            </div>
        </div>
        <div class="flex items-center space-x-2 relative">
            <div class="w-8 h-8 rounded-full bg-blue-100 flex items-center justify-center">
                <span class="text-blue-600 font-medium text-sm">
                    <?php echo strtoupper(substr($current_user['name'], 0, 2)); ?>
                </span>
            </div>
            <div class="cursor-pointer" onclick="toggleUserMenu()">
                <span class="text-sm font-medium"><?php echo escape($current_user['name']); ?></span>
                <p class="text-xs text-gray-500"><?php echo escape($current_user['position']); ?></p>
            </div>
            <i data-feather="chevron-down" class="w-4 h-4 text-gray-400"></i>
            
            <!-- User dropdown menu -->
            <div id="user-dropdown" class="hidden absolute right-0 top-full mt-2 w-48 bg-white rounded-lg shadow-lg border z-50">
                <div class="p-2">
                    <a href="profile.php" class="flex items-center space-x-2 px-3 py-2 text-sm text-gray-700 hover:bg-gray-100 rounded">
                        <i data-feather="user" class="w-4 h-4"></i>
                        <span>Profil</span>
                    </a>
                    <a href="settings.php" class="flex items-center space-x-2 px-3 py-2 text-sm text-gray-700 hover:bg-gray-100 rounded">
                        <i data-feather="settings" class="w-4 h-4"></i>
                        <span>Pengaturan</span>
                    </a>
                    <hr class="my-2">
                    <a href="logout.php" class="flex items-center space-x-2 px-3 py-2 text-sm text-red-600 hover:bg-red-50 rounded">
                        <i data-feather="log-out" class="w-4 h-4"></i>
                        <span>Keluar</span>
                    </a>
                </div>
            </div>
        </div>
    </div>
</header>

<script>
// Toggle functions
function toggleSidebar() {
    document.querySelector('.sidebar').classList.toggle('hidden');
}

function toggleNotifications() {
    const dropdown = document.getElementById('notification-dropdown');
    dropdown.classList.toggle('hidden');
    // Hide user dropdown if open
    document.getElementById('user-dropdown').classList.add('hidden');
}

function toggleUserMenu() {
    const dropdown = document.getElementById('user-dropdown');
    dropdown.classList.toggle('hidden');
    // Hide notification dropdown if open
    document.getElementById('notification-dropdown').classList.add('hidden');
}

// Close dropdowns when clicking outside
document.addEventListener('click', function(event) {
    const notificationBtn = event.target.closest('button[onclick="toggleNotifications()"]');
    const userMenuBtn = event.target.closest('[onclick="toggleUserMenu()"]');
    const notificationDropdown = document.getElementById('notification-dropdown');
    const userDropdown = document.getElementById('user-dropdown');
    
    if (!notificationBtn && !notificationDropdown.contains(event.target)) {
        notificationDropdown.classList.add('hidden');
    }
    
    if (!userMenuBtn && !userDropdown.contains(event.target)) {
        userDropdown.classList.add('hidden');
    }
});
</script>