<?php
require_once 'config/config.php';

// Require login
$auth->requireLogin();

$page_title = 'Dashboard';
$current_user = $auth->getCurrentUser();

// Get statistics
try {
    // Total pengajuan user ini
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM permissions WHERE user_id = ?");
    $stmt->execute([$current_user['id']]);
    $total_pengajuan = $stmt->fetchColumn();
    
    // Disetujui
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM permissions WHERE user_id = ? AND status = 'approved'");
    $stmt->execute([$current_user['id']]);
    $disetujui = $stmt->fetchColumn();
    
    // Menunggu
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM permissions WHERE user_id = ? AND status = 'pending'");
    $stmt->execute([$current_user['id']]);
    $menunggu = $stmt->fetchColumn();
    
    // Ditolak
    $stmt = $pdo->prepare("SELECT COUNT(*) FROM permissions WHERE user_id = ? AND status = 'rejected'");
    $stmt->execute([$current_user['id']]);
    $ditolak = $stmt->fetchColumn();
    
    // Recent requests
    $stmt = $pdo->prepare("
        SELECT p.*, pt.name as permission_type_name, u.name as approved_by_name
        FROM permissions p
        LEFT JOIN permission_types pt ON p.permission_type_id = pt.id
        LEFT JOIN users u ON p.approved_by = u.id
        WHERE p.user_id = ?
        ORDER BY p.created_at DESC
        LIMIT 5
    ");
    $stmt->execute([$current_user['id']]);
    $recent_requests = $stmt->fetchAll();
    
} catch(PDOException $e) {
    $total_pengajuan = $disetujui = $menunggu = $ditolak = 0;
    $recent_requests = [];
}
?>
<!DOCTYPE html>
<html lang="id">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title><?php echo $page_title; ?> - SISKIM PN Watampone</title>
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://unpkg.com/aos@2.3.1/dist/aos.css" rel="stylesheet">
    <script src="https://unpkg.com/aos@2.3.1/dist/aos.js"></script>
    <script src="https://cdn.jsdelivr.net/npm/feather-icons/dist/feather.min.js"></script>
    <script src="https://unpkg.com/feather-icons"></script>
    <style>
        .sidebar {
            transition: all 0.3s;
        }
        .nav-item.active {
            background-color: #1e3a8a;
            color: white;
        }
        .nav-item.active svg {
            color: white;
        }
        .status-approved {
            background-color: #05966920;
            color: #059669;
        }
        .status-pending {
            background-color: #d9770620;
            color: #d97706;
        }
        .status-rejected {
            background-color: #dc262620;
            color: #dc2626;
        }
    </style>
</head>
<body class="bg-gray-50">
    <div class="flex h-screen overflow-hidden">
        <!-- Sidebar -->
        <?php include 'includes/sidebar.php'; ?>

        <!-- Main Content -->
        <div class="flex-1 overflow-auto">
            <!-- Header -->
            <?php include 'includes/header.php'; ?>

            <!-- Content -->
            <main class="p-6">
                <!-- Flash Messages -->
                <?php showFlashMessage(); ?>
                
                <!-- Welcome Message -->
                <div class="bg-gradient-to-r from-blue-600 to-blue-700 rounded-lg text-white p-6 mb-6">
                    <h1 class="text-2xl font-bold">Selamat datang, <?php echo escape($current_user['name']); ?>!</h1>
                    <p class="text-blue-100 mt-1"><?php echo escape($current_user['position'] . ' - ' . $current_user['department']); ?></p>
                    <p class="text-blue-100 text-sm mt-2">Kelola pengajuan izin Anda dengan mudah melalui sistem ini.</p>
                </div>
                
                <!-- Stats Cards -->
                <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6 mb-6">
                    <div class="bg-white rounded-lg shadow p-6">
                        <div class="flex items-center justify-between">
                            <div>
                                <p class="text-sm text-gray-500">Total Pengajuan</p>
                                <h3 class="text-2xl font-bold mt-1"><?php echo $total_pengajuan; ?></h3>
                            </div>
                            <div class="p-3 rounded-full bg-blue-100 text-blue-600">
                                <i data-feather="file-text" class="w-6 h-6"></i>
                            </div>
                        </div>
                    </div>
                    <div class="bg-white rounded-lg shadow p-6">
                        <div class="flex items-center justify-between">
                            <div>
                                <p class="text-sm text-gray-500">Disetujui</p>
                                <h3 class="text-2xl font-bold mt-1"><?php echo $disetujui; ?></h3>
                            </div>
                            <div class="p-3 rounded-full bg-green-100 text-green-600">
                                <i data-feather="check-circle" class="w-6 h-6"></i>
                            </div>
                        </div>
                    </div>
                    <div class="bg-white rounded-lg shadow p-6">
                        <div class="flex items-center justify-between">
                            <div>
                                <p class="text-sm text-gray-500">Menunggu</p>
                                <h3 class="text-2xl font-bold mt-1"><?php echo $menunggu; ?></h3>
                            </div>
                            <div class="p-3 rounded-full bg-yellow-100 text-yellow-600">
                                <i data-feather="clock" class="w-6 h-6"></i>
                            </div>
                        </div>
                    </div>
                    <div class="bg-white rounded-lg shadow p-6">
                        <div class="flex items-center justify-between">
                            <div>
                                <p class="text-sm text-gray-500">Ditolak</p>
                                <h3 class="text-2xl font-bold mt-1"><?php echo $ditolak; ?></h3>
                            </div>
                            <div class="p-3 rounded-full bg-red-100 text-red-600">
                                <i data-feather="x-circle" class="w-6 h-6"></i>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- Recent Requests -->
                <div class="bg-white rounded-lg shadow overflow-hidden mb-6">
                    <div class="p-6 border-b border-gray-200">
                        <div class="flex justify-between items-center">
                            <h2 class="text-lg font-semibold">Pengajuan Terbaru</h2>
                            <a href="riwayat.php" class="text-sm text-blue-600 hover:underline">Lihat Semua</a>
                        </div>
                    </div>
                    <div class="overflow-x-auto">
                        <?php if (!empty($recent_requests)): ?>
                        <table class="min-w-full divide-y divide-gray-200">
                            <thead class="bg-gray-50">
                                <tr>
                                    <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Tanggal</th>
                                    <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Jenis Izin</th>
                                    <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Waktu</th>
                                    <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Status</th>
                                    <th scope="col" class="px-6 py-3 text-left text-xs font-medium text-gray-500 uppercase tracking-wider">Aksi</th>
                                </tr>
                            </thead>
                            <tbody class="bg-white divide-y divide-gray-200">
                                <?php foreach ($recent_requests as $request): ?>
                                <tr>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                        <?php echo formatTanggalIndonesia($request['request_date']); ?>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-900">
                                        <?php echo escape($request['permission_type_name']); ?>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm text-gray-500">
                                        <?php echo formatWaktu($request['start_time']) . ' - ' . formatWaktu($request['end_time']); ?>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap">
                                        <?php echo getStatusBadge($request['status']); ?>
                                    </td>
                                    <td class="px-6 py-4 whitespace-nowrap text-sm font-medium">
                                        <a href="detail.php?id=<?php echo $request['id']; ?>" class="text-blue-600 hover:text-blue-900">Detail</a>
                                    </td>
                                </tr>
                                <?php endforeach; ?>
                            </tbody>
                        </table>
                        <?php else: ?>
                        <div class="p-6 text-center text-gray-500">
                            <i data-feather="inbox" class="w-12 h-12 mx-auto mb-4 text-gray-300"></i>
                            <p>Belum ada pengajuan izin</p>
                            <a href="pengajuan.php" class="inline-block mt-2 text-blue-600 hover:underline">Ajukan izin pertama Anda</a>
                        </div>
                        <?php endif; ?>
                    </div>
                </div>

                <!-- Quick Actions -->
                <div class="grid grid-cols-1 md:grid-cols-2 gap-6">
                    <div class="bg-white rounded-lg shadow p-6">
                        <h3 class="text-lg font-semibold mb-4">Ajukan Izin Baru</h3>
                        <div class="space-y-4">
                            <a href="pengajuan.php?type=1" class="w-full flex items-center justify-between p-4 border border-gray-200 rounded-lg hover:bg-gray-50">
                                <div class="flex items-center space-x-3">
                                    <div class="p-2 rounded-full bg-blue-100 text-blue-600">
                                        <i data-feather="briefcase" class="w-5 h-5"></i>
                                    </div>
                                    <span>Dinas Luar</span>
                                </div>
                                <i data-feather="chevron-right" class="w-5 h-5 text-gray-400"></i>
                            </a>
                            <a href="pengajuan.php?type=2" class="w-full flex items-center justify-between p-4 border border-gray-200 rounded-lg hover:bg-gray-50">
                                <div class="flex items-center space-x-3">
                                    <div class="p-2 rounded-full bg-purple-100 text-purple-600">
                                        <i data-feather="user" class="w-5 h-5"></i>
                                    </div>
                                    <span>Keperluan Pribadi</span>
                                </div>
                                <i data-feather="chevron-right" class="w-5 h-5 text-gray-400"></i>
                            </a>
                            <a href="pengajuan.php?type=3" class="w-full flex items-center justify-between p-4 border border-gray-200 rounded-lg hover:bg-gray-50">
                                <div class="flex items-center space-x-3">
                                    <div class="p-2 rounded-full bg-red-100 text-red-600">
                                        <i data-feather="heart" class="w-5 h-5"></i>
                                    </div>
                                    <span>Sakit</span>
                                </div>
                                <i data-feather="chevron-right" class="w-5 h-5 text-gray-400"></i>
                            </a>
                            <a href="pengajuan.php" class="w-full flex items-center justify-between p-4 border border-gray-200 rounded-lg hover:bg-gray-50">
                                <div class="flex items-center space-x-3">
                                    <div class="p-2 rounded-full bg-gray-100 text-gray-600">
                                        <i data-feather="plus" class="w-5 h-5"></i>
                                    </div>
                                    <span>Lainnya</span>
                                </div>
                                <i data-feather="chevron-right" class="w-5 h-5 text-gray-400"></i>
                            </a>
                        </div>
                    </div>
                    
                    <div class="bg-white rounded-lg shadow p-6">
                        <h3 class="text-lg font-semibold mb-4">Menu Lainnya</h3>
                        <div class="space-y-4">
                            <a href="riwayat.php" class="w-full flex items-center justify-between p-4 border border-gray-200 rounded-lg hover:bg-gray-50">
                                <div class="flex items-center space-x-3">
                                    <div class="p-2 rounded-full bg-green-100 text-green-600">
                                        <i data-feather="clock" class="w-5 h-5"></i>
                                    </div>
                                    <span>Riwayat Izin</span>
                                </div>
                                <i data-feather="chevron-right" class="w-5 h-5 text-gray-400"></i>
                            </a>
                            <a href="kalender.php" class="w-full flex items-center justify-between p-4 border border-gray-200 rounded-lg hover:bg-gray-50">
                                <div class="flex items-center space-x-3">
                                    <div class="p-2 rounded-full bg-indigo-100 text-indigo-600">
                                        <i data-feather="calendar" class="w-5 h-5"></i>
                                    </div>
                                    <span>Kalender Izin</span>
                                </div>
                                <i data-feather="chevron-right" class="w-5 h-5 text-gray-400"></i>
                            </a>
                            <a href="profile.php" class="w-full flex items-center justify-between p-4 border border-gray-200 rounded-lg hover:bg-gray-50">
                                <div class="flex items-center space-x-3">
                                    <div class="p-2 rounded-full bg-yellow-100 text-yellow-600">
                                        <i data-feather="user" class="w-5 h-5"></i>
                                    </div>
                                    <span>Profil</span>
                                </div>
                                <i data-feather="chevron-right" class="w-5 h-5 text-gray-400"></i>
                            </a>
                        </div>
                    </div>
                </div>
            </main>
        </div>
    </div>

    <script>
        AOS.init();
        feather.replace();
        
        // Mobile menu toggle
        function toggleSidebar() {
            document.querySelector('.sidebar').classList.toggle('hidden');
        }
    </script>
</body>
</html>